% LasfProjGeoAsciiParamsTagVLR   LASF_Projection: GeoTIFF Tag - ASCII Parameters
%
% File:
%    LasfProjGeoAsciiParamsTagVLR.m
%
% Description:
%    This MATLAB class represents a VLR that contains an array of ASCII data. It
%    contains many strings separated by null terminator characters which are
%    referenced by position from data in the GeoKeyDirectoryTag record.
%
% Limitations:
%    None.
%
% Properties:
%    params                   - The ASCII Parameters
%    userID                   - The User Identifier
%    recordID                 - The Record Identifier
%    recordLengthAfterHeader  - The Record Length After Header
%    description              - The Description
%    data                     - The Data
%
% Methods:
%    [this] = LasfProjGeoAsciiParamsTagVLR(varargin)  - Constructor.
%             saveTo(location)                        - Save LAS VLR to a given
%                                                       location.
%
% Toolbox requirements:
%    None.
%
% Script requirements:
%    LasVlr.m
%
% MAT-files required:
%    None.
%
% References:
%    http://asprs.org/a/society/committees/standards/asprs_las_format_v12.pdf
%    http://www.remotesensing.org/geotiff/spec/geotiffhome.html
%
% See Also:
%    LasFile
%    LasVlr
%    LasfProjGeoKeyDirectoryTagVLR
%

% Software History:
%    2012-AUG-29   K. Damkjer
%       Initial Coding.
%    2013-JUN-17   K. Damkjer
%       Additional Commenting.
%

classdef (Sealed = true) LasfProjGeoAsciiParamsTagVLR < LasVlr
   properties
      params
   end
   
   methods
      function vlr = LasfProjGeoAsciiParamsTagVLR(varargin)
         if (nargin == 0)
            superargs = {};
         elseif (nargin == 1)
            if (~isa(varargin{1},'LasVlr'))
               error('LasfProjGeoDoubleParamsTagVLR:InitError',...
                     'Unknown argument initializer.');
            end
            
            vlrHeader = varargin{1};
            
            superargs{1} = vlrHeader;
         else
            error('LasfProjGeoDoubleParamsTagVLR:InitError',...
                  'Unexpected number of inputs.');
         end
         
         vlr = vlr@LasVlr(superargs{:});
         
         if (nargin == 1)
            % The GeoAsciiParamsTag data is a stream of null-terminated strings
            vlr.params = char(vlrHeader.data);
         end
      end
   end
end
