% lasVlrFactory   Abstract factory for LAS VLR objects
%
% File:
%    lasVlrFactory.m
%
% Description:
%    This MATLAB function provides an interface similar to an abstract factory
%    design pattern for constructing known LAS VLR objects.
%
% Limitations:
%    None.
%
% Synopsis:
%    [vlr] = lasVlrFactory(vlrHeader)
%
% Inputs:
%    vlrHeader  - A LAS VLR object containing populated header data
%
% Outputs:
%    vlr  - A specialized LAS VLR object
%
% Toolbox requirements:
%    None.
%
% Script requirements:
%    LasVlr.m
%    lasfProjVlrFactory.m
%    lasfSpecVlrFactory.m
%
% Data requirements:
%    None.
%
% References:
%    http://asprs.org/a/society/committees/standards/asprs_las_format_v12.pdf
%
% See Also:
%    LasFile
%    LasVlr
%    lasfProjVlrFactory
%    lasfSpecVlrFactory
%

% Copyright (C)  2012 Kristian L. Damkjer.
%
% Software History:
%    2012-AUG-29   K. Damkjer
%       Initial Coding.
%    2013-JUN-17   K. Damkjer
%       Additional Commenting.
%

function [vlr] = lasVlrFactory(vlrHeader)

switch vlrHeader.userID
   case 'LASF_Projection'
      vlr = lasfProjVlrFactory(vlrHeader);
   case 'LASF_Spec'
      vlr = lasfSpecVlrFactory(vlrHeader);
   otherwise
      disp(vlrHeader.userID);
      disp(vlrHeader.description);
end
end
