//*****************************************************************************
// FILE:        Metrics.h
//
//    Copyright (C)  2012 Kristian Damkjer.
//
// DESCRIPTION: 
//
// LIMITATIONS:
//
// SOFTWARE HISTORY:
//> 2012-SEP-11  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#ifndef Metrics_HEADER
#define Metrics_HEADER

#include <cmath>

namespace Damkjer
{

//*****************************************************************************
// FUNCTION: euclidean
//*****************************************************************************
template<typename CONTAINER>
double euclidean(const CONTAINER& a,
                 const CONTAINER& b)
{
    double sum = 0;
    
    for (typename CONTAINER::const_iterator ai = a.begin(), bi = b.begin();
         ai != a.end() && bi != b.end();
         ++ai, ++bi)
    {
        sum += (*ai - *bi) * (*ai - *bi);
    }
    
    return sqrt(sum);
}

//*****************************************************************************
// FUNCTION: manhattan
//*****************************************************************************
template<typename CONTAINER>
double manhattan(const CONTAINER& a,
                 const CONTAINER& b)
{
    double sum = 0;
    
    for (typename CONTAINER::const_iterator ai = a.begin(), bi = b.begin();
         ai != a.end() && bi != b.end();
         ++ai, ++bi)
    {
        sum += fabs(*ai - *bi);
    }
    
    return sum;
}

//*****************************************************************************
// FUNCTION: maximum
//*****************************************************************************
template<typename CONTAINER>
double maximum(const CONTAINER& a,
               const CONTAINER& b)
{
    double my_max = 0;
    
    for (typename CONTAINER::const_iterator ai = a.begin(), bi = b.begin();
         ai != a.end() && bi != b.end();
         ++ai, ++bi)
    {
       double temp = fabs(*ai - *bi)
       my_max = (temp > my_max) ? temp : my_max;
    }
    
    return my_max;
}

//*****************************************************************************
// FUNCTION: pNorm
//*****************************************************************************
// template<typename CONTAINER>
// double pNorm(const CONTAINER& a,
//              const CONTAINER& b)
// {
//    double sum = 0;
//    
//    for (typename CONTAINER::const_iterator ai = a.begin(), bi = b.begin();
//         ai != a.end() && bi != b.end();
//         ++ai, ++bi)
//    {
//       sum += pow((*ai - *bi), theP);
//    }
//    
//    return pow(sum, 1./theP);
// }

}

#endif
