//*****************************************************************************
// FILE:        fastsetdual.cpp
//
//    Copyright (C)  2014 Kristian Damkjer.
//
// DESCRIPTION:
//>   @todo Describe this file
//<
//
// LIMITATIONS:
//>   Does not work for cell-arrays of complex matrices.
//<
//
// SOFTWARE HISTORY:
//> 2014-JAN-13  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#ifdef _OPENMP
#include <omp.h>
#endif

#include <deque>
#include <vector>
#include <sstream>

//***
// Fix "wide char" definition for older versions of MATLAB. This must be placed
// after other includes and before the mex.h include.
//***
#if (defined(MATLAB_MAJOR) && defined(MATLAB_MINOR))
   #if MATLAB_MAJOR <= 7 && MATLAB_MINOR <= 10 && defined(_CHAR16T)
      #define CHAR16_T
   #endif
#endif

#include "mex.h"

//*****************************************************************************
// FUNCTION: mexFunction
//>   The MATLAB Executable Gateway Function.
//
//    @todo Describe this MEX function
//
//    @param nlhs the number of left-hand side parameters.
//    @param plhs the array of left-hand side parameters.
//    @param nrhs the number of right-hand side parameters.
//    @param prhs the array of right-hand side parameters.
//<
//*****************************************************************************
void mexFunction(
        int nlhs, mxArray* plhs[],
        int nrhs, const mxArray* prhs[])
{
   if (nrhs != 1 || !mxIsCell(prhs[0]))
   {
      mexErrMsgIdAndTxt("Damkjer:fastsetdual:varargin",
                        "Missing or invalid input argument.");
   }

   if (!(mxIsUint32(mxGetCell(prhs[0], 0)) ||
         mxIsUint64(mxGetCell(prhs[0], 0))))
   {
      mexErrMsgIdAndTxt("Damkjer:fastsetdual:varargin",
                        "Invalid input argument.");
   }

   if (nlhs != 1)
   {
      mexErrMsgIdAndTxt("Damkjer:fastsetdual:varargout",
                        "Fast set dual requires a single output.");
   }
   
   mwSize cells = mxGetNumberOfElements (prhs[0]);

   std::vector<const mwSize*> nbrs(cells,0);
   std::vector<mwSize> Ms(cells,0);
   std::vector<mwSize> Ns(cells,0);

   mwSize maxElem = 0;
   
   // Note for future: Ms - neighbors, Ns - 1
   for (mwSize cell = 0; cell < cells; ++cell)
   {      
      nbrs[cell]=(mwIndex*)(mxGetData(mxGetCell(prhs[0], cell)));
      Ms[cell]=mxGetM(mxGetCell(prhs[0], cell));
      Ns[cell]=mxGetN(mxGetCell(prhs[0], cell));
       
      for (mwSize n = Ns[cell]; n --> 0;)
      {
         for (mwSize m = Ms[cell]; m --> 0;)
         {
            mwSize idx = nbrs[cell][m + Ms[cell] * n];
            maxElem = (idx > maxElem) ? idx : maxElem;
         }
      }
   }
   
   std::deque<std::vector<mwSize> > duals(maxElem);

   for (mwSize cell = 0; cell < cells; ++cell)
   {
      for (mwSize n = Ns[cell]; n --> 0;)
      {
         for (mwSize m = Ms[cell]; m --> 0;)
         {
            mwIndex idx = nbrs[cell][m + Ms[cell] * n];
            duals[idx-1].push_back(cell + 1);
         }  
      }
   }
   
   plhs[0] = mxCreateCellMatrix(maxElem, 1);
   
   std::deque<mxArray*> returns;
   std::deque<mwIndex*> return_data;
   
   //***
   // Allocating memory for the results to be passed back to MATLAB must take
   // place in a "critical section" since it involves exercising the MEX API.
   //***
   for (std::size_t elem = 0; elem < maxElem; ++elem)
   {
      mwSize neighborhoods = duals[elem].size();

      returns.push_back(mxCreateNumericMatrix(0, 0, mxINDEX_CLASS, mxREAL));
      mxSetM(returns[elem], neighborhoods);
      mxSetN(returns[elem], 1);
      mxSetData(returns[elem], mxMalloc(sizeof(mwIndex)*neighborhoods*1));
      
      return_data.push_back((mwIndex*)mxGetData(returns[elem]));
   }

   //***
   // Once memory has been allocated, the actual results can be populated in
   // parallel.
   //***
   #pragma omp parallel for schedule(guided)
   for (int elem = 0; elem < maxElem; ++elem)
   {  
      std::size_t size_elem = static_cast<std::size_t>(elem);
      mwSize neighborhoods = duals[elem].size();

      mwIndex* data = return_data[size_elem];
      
      for (mwIndex idx = neighborhoods; idx --> 0;)
      {
         data[idx]=duals[elem][idx];
      }
   }

   //***
   // Marking the data for return to MATLAB must take place in a "critical 
   // section" since it involves exercising the MEX API. This also changes
   // ownership and memory management responsibilities to MATLAB. We will not
   // free this data.
   //***   
   for (std::size_t elem = 0; elem < maxElem; ++elem)
   {
      mxSetCell(plhs[0], elem, returns[elem]);
   }
}
