function O=bb_diffuse(I,R,k,t,idxs,mask)

H=fspecial('gaussian');
I=imfilter(I,H,'replicate');

   [Ix, Iy] = grad(I);
   [Ixx,Ixy,Iyy] = fdiff2(I);
   Ix2 = Ix.^2;
   Iy2 = Iy.^2;
   norm2 = Ix2+Iy2+1e-10;
   
   g=(1./(1+k.*norm2));
   
   num=(Ix2.*Iyy-2.*Ix.*Iy.*Ixy+Iy2.*Ixx);
   sub=(1-g).*(I-R);
   
   diff = (g).*(num./norm2)-sub;
   
   O=min(max(0,I+t.*diff),1);
   
if (nargin<5)
   return
end

[Ix, Iy] = grad(I,idxs);
[Ixx,Ixy,Iyy] = fdiff2(I,idxs);
Ix2 = Ix.^2;
Iy2 = Iy.^2;
norm2 = Ix2 + Iy2 + 1e-10;

O=I;

%diff=Ix2.*Iyy-2.*Ix.*Iy.*Ixy+Iy2.*Ixx./norm2;
%O(mask)=I(mask) + t * diff;

for idx=1:size(idxs,1)
    x=idxs(idx,2);
    y=idxs(idx,1);
    
    diff = ((Ix2(idx).*Iyy(idx)...
        -2.*Ix(idx).*Iy(idx).*Ixy(idx)...
        +Iy2(idx).*Ixx(idx)))./...
        (norm2(idx));
    O(y,x) = I(y,x) + t * diff;
end
