function J=bb_inpaint(I,varargin)
% BB_INPAINT: in-paints over nans in an matrix
% usage: B=BB_INPAINT(A)          % default method

% Parse inputs
p = inputParser;
defaultPaintSteps = 15;%10
defaultSmoothSteps = 2;%10
defaultPaintTimeSlice = 0.02;
defaultSmoothTimeSlice = 0.2;
defaultPreservation = 0.5;
defaultIters = 300;

addRequired(p, 'I', @isfloat);
addOptional(p, 'PaintSteps', defaultPaintSteps, @isnumeric);
addOptional(p, 'SmoothSteps', defaultSmoothSteps, @isnumeric);
addOptional(p, 'Iters', defaultIters, @isnumeric);
addOptional(p, 'PaintTimeSlice', defaultPaintTimeSlice, @isfloat);
addOptional(p, 'SmoothTimeSlice', defaultSmoothTimeSlice, @isfloat);
addOptional(p, 'Preservation', defaultPreservation, @isfloat);

% Establish default parameters
parse(p,I,varargin{:});
I=p.Results.I;
A=p.Results.PaintSteps;
B=p.Results.SmoothSteps;
T=p.Results.Iters;
ti=p.Results.PaintTimeSlice;
ts=p.Results.SmoothTimeSlice;
k=p.Results.Preservation*1e5;

%Determine Omega (the inpaint region)
mask=zeros(size(I));
mask=isnan(I);

%P=I/255;
%P=I;
%P(mask)=0.5;
P=bscb_preproc(I);

J=P;
R=P;

[r,c]=ind2sub(size(I),find(mask(:)));
mask2=[r,c];

size(mask2)

h = waitbar(0,'Pre-Processing...');

% Pre-processing: the whole image undergoes anisotropic diffusion smoothing
P=bb_diffuse(P,R,k,ts);

close(h);

h = waitbar(0,'In Painting...');

for pass=1:T;

   for i=1:A
      % Equation (8)
        [Ix,Iy] = grad(P, mask2);
        [Ixxx,Ixxy,Ixyy,Iyyy]=fdiff3(P,mask2);

%        It=Ix.*(Ixxy+Iyyy)-Iy.*(Ixxx+Ixyy);
%        P(mask)=min(max(0,P(mask)+ti.*It),1);

        
        for idx=1:size(mask2,1)
            x=mask2(idx,2);
            y=mask2(idx,1);

            It=Ix(idx)*(Ixxy(idx)+Iyyy(idx))-Iy(idx)*(Ixxx(idx)+Ixyy(idx));

            P(y,x)=min(max(0,P(y,x)+ti*It),1);
        end
    end
    
    for j = 1:B
       P=bb_diffuse(P,R,k,ts,mask2,mask);
    end
    
    J(mask)=P(mask);
    
    if (mod(pass,10) == 0||pass==1||pass==T)
        f=figure(2);
        imshow(J);
        pause(0.01);
    end
    
    if (all(ishghandle(h, 'figure')))
        waitbar(pass/T,h,['In Painting...' num2str(pass) '/' num2str(T)]);
    else
        h = waitbar(pass/T,['In Painting...' num2str(pass) '/' num2str(T)]);
    end
end

close(f);
close(h);
