% [OUT]=BSCB_PREPROC(IN,...) Pre-processing for BSCB in-painting.
%
%   Copyright 2012 Kristian L. Damkjer
%
%   Software History:
%      2013-FEB-04   K. Damkjer
%         Initial Coding.
%
function J=bscb_preproc(Image,varargin)

% Parse inputs
p = inputParser;

addRequired(p, 'Image', @isfloat);

% Establish default parameters
parse(p,Image,varargin{:});
Image=p.Results.Image;

J=Image;

%Determine Omega (the inpaint region)
mask=zeros(size(J));
mask(isnan(J))=1;
labels=bwlabel(mask,8);

regions=max(max(labels));

for region=1:regions
   roi=(labels==region);
   del=bwmorph(roi,'dilate',1);
   avg=nanmean(Image(del==1));
   std=nanstd(Image(del==1));
   J(roi==1)=avg+std.*randn(size(J(roi==1)));
end
