%FDIFF3 Numerical Second Differential.
%   [FXX,FXY,FYY] = FDIFF2(F) returns the numerical second partial derivative of
%   the matrix F. The spacing between points in each direction is assumed to be
%   one.
%
%   [FXX,FXY,FYY] = FDIFF3(F,IDXS), where IDXS is a 2-D array, computes
%   numerical third partial derivative at the locations specified by IDXS.
%
%   Copyright 2012 Kristian L. Damkjer
%
%   Software History:
%      2012-AUG-29   K. Damkjer
%         Initial Coding.
%      2013-FEB-04   K. Damkjer
%         Updated output sizes or indexed case.
%

function [Oxx,Oxy,Oyy] = fdiff2( I,idxs )

if (nargin<2)
    Ipp = zeros(size(I));
    Icp = zeros(size(I));
    Inp = zeros(size(I));
    Ipc = zeros(size(I));
    Inc = zeros(size(I));
    Ipn = zeros(size(I));
    Icn = zeros(size(I));
    Inn = zeros(size(I));

    Ipp(2:end,2:end)    =I(1:end-1,1:end-1);
    Icp(2:end,:)        =I(1:end-1,:);
    Inp(2:end,1:end-1)  =I(1:end-1,2:end);
    Ipc(:,2:end)        =I(:,1:end-1);
    Inc(:,1:end-1)      =I(:,2:end);
    Ipn(1:end-1,2:end)  =I(2:end,1:end-1);
    Icn(1:end-1,:)      =I(2:end,:);
    Inn(1:end-1,1:end-1)=I(2:end,2:end);

    Nxy=4*ones(size(I));

%     Nxy(1,:)  =Nxy(1,:)-2;
%     Nxy(end,:)=Nxy(end,:)-2;
%     Nxy(:,1)  =Nxy(:,1)-2;
%     Nxy(:,end)=Nxy(:,end)-2;
%     Nxy(Nxy==0)=1;

    Oxx=(Ipc-2*I+Inc);
    Oxy=(Ipp-Inp-Ipn+Inn)./Nxy;
    Oyy=(Icp-2*I+Icn);
else
    Oxx = zeros(size(idxs,1),1);
    Oxy = zeros(size(idxs,1),1);
    Oyy = zeros(size(idxs,1),1);

    for idx=1:size(idxs,1)
        x=idxs(idx,2);
        y=idxs(idx,1);
        
        xp=max(1,x-1);
        xn=min(x+1,size(I,2));
        yp=max(1,y-1);
        yn=min(y+1,size(I,1));
        
        Ipp=I(yp,xp);
        Icp=I(yp,x);
        Inp=I(yp,xn);
        Ipc=I(y,xp);
        Icc=I(y,x);
        Inc=I(y,xn);
        Ipn=I(yn,xp);
        Icn=I(yn,x);
        Inn=I(yn,xn);
        
        Oxx(idx)=(-2*Icc+Ipc+Inc);
        Oxy(idx)=0.25*(Inn-Inp-Ipn+Ipp);
        Oyy(idx)=(-2*Icc+Icp+Icn);
    end
end
