%GRAD Numerical Gradient.
%   [FX,FY] = GRAD(F) returns the numerical central gradient of the
%   matrix F. FX corresponds to dF/dx, the differences in x (horizontal) 
%   direction. FY corresponds to dF/dy, the differences in y (vertical) 
%   direction. The spacing between points in each direction is assumed to 
%   be one.
%
%   [FX,FY] = GRAD(F,IDXS), where IDXS is a 2-D array, computes the
%   central gradient at the locations specified by IDXS.
%
%   Note: The first output FX is always the gradient along the 2nd
%   dimension of F, going across columns.  The second output FY is always
%   the gradient along the 1st dimension of F, going across rows.
%
%   Copyright 2012 Kristian L. Damkjer
%
%   Software History:
%      2012-AUG-29   K. Damkjer
%         Initial Coding.
%      2013-FEB-04   K. Damkjer
%         Updated output sizes or indexed case.
%

function [Ox,Oy]=grad(I,idxs)

if (nargin<2)
    [Ox,Oy]=gradient(I);
else
    Ox=zeros(size(idxs,1),1);
    Oy=zeros(size(idxs,1),1);

    for idx=1:size(idxs,1)
        x=idxs(idx,2);
        y=idxs(idx,1);
        
        xp=max(1,x-1);
        xn=min(x+1,size(I,2));
        yp=max(1,y-1);
        yn=min(y+1,size(I,1));
        
        Icp=I(yp,x);
        Ipc=I(y,xp);
        Inc=I(y,xn);
        Icn=I(yn,x);
        
        Ox(idx)=0.50*(Inc-Ipc);
        Oy(idx)=0.50*(Icn-Icp);
    end
end
