%ISOPHOTE Compute isophote directions.
%   [NX,NY] = ISOPHOTE(F) returns the estimate of the isophote direction as the
%   direction perpendicular to gradient. Orientation arbitrarily selected as CW
%   rotation of gradient (alternative would be CCW rotation of gradient).
%
%   Copyright 2012 Kristian L. Damkjer
%
%   Software History:
%      2012-AUG-29   K. Damkjer
%         Initial Coding.
%      2013-FEB-04   K. Damkjer
%         Updated to remove normalization to improve convergence and stability.
%         Should add an option to enable and disable normalizing.
%

function [Ox,Oy]=isophote(Ix,Iy)

Ox=zeros(size(Ix));
Oy=zeros(size(Ix));

for idx=1:length(Ix)
%    M=sqrt(Ix(idx)^2+Iy(idx)^2+1e-6);
    M=1;

    Ox(idx) = -Iy(idx) / M;
    Oy(idx) =  Ix(idx) / M;
end
