//*****************************************************************************
// FILE:        Metrics.h
//
//    Copyright (C)  2012 Kristian Damkjer.
//
// DESCRIPTION:
//>  A convenience inclusion wrapper for defined metrics.
//<
//
// LIMITATIONS:
//>  No known limitations.
//<
//
// SOFTWARE HISTORY:
//> 2012-SEP-11  K. Damkjer
//               Initial Coding.
//  2013-JUL-23  K. Damkjer
//               Modified free functions to functors to allow for "functions
//               with state" like p-norm.
//  2013-AUG-09  K. Damkjer
//               Moved individual metrics into their own headers to improve
//               maintainability.
//<
//*****************************************************************************

#ifndef Damkjer_Metrics_HEADER
#define Damkjer_Metrics_HEADER

#include "Util/SpatialIndexing/Metrics/EuclideanDistance.h"
#include "Util/SpatialIndexing/Metrics/ManhattanDistance.h"
#include "Util/SpatialIndexing/Metrics/ChebyshevDistance.h"
#include "Util/SpatialIndexing/Metrics/MinkowskiDistance.h"

#endif
