//*****************************************************************************
// FILE:        BlockIndent.h
//
//    Copyright (C)  2013 Kristian Damkjer.
//
// DESCRIPTION: 
//>   The interface definition for the block indentation output stream
//    manipulator.
//<
//
// LIMITATIONS: 
//>   No known limitations.
//<
//
// SOFTWARE HISTORY:
//> 2013-JUL-26  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#ifndef Damkjer_BlockIndent_HEADER
#define Damkjer_BlockIndent_HEADER

#if _MSC_VER
#pragma warning(push, 0)
#endif

#include <iosfwd>
#include <deque>

#if _MSC_VER
#pragma warning(pop)
#endif

#include "Util/UtilAPI.h"
#include "Util/Streams/ManipulatorBase.h"

namespace Damkjer
{

Util_API std::ostream& endBlock(std::ostream&);
   //> End the current block indentation in the specified output stream.
   //<

//*****************************************************************************
// FUNCTOR: BlockIndent
//>   An output stream manipulator for performing block indentation.
//
//    This class performs the function of block-indenting a stream. It is a
//    convenience manipulator based heavily on the code provided at:
//
//    http://stackoverflow.com/questions/5280858/indenting-paragraph-with-cout
//<
//*****************************************************************************
class BlockIndent : public ManipulatorBase<BlockIndent>
{
public:
   Util_API explicit BlockIndent(long indent = 3)
      : ManipulatorBase<BlockIndent>()
      , theNumSpaces(indent)
   {
   }
      //> Instantiate a block indentation manipulator with a number of spaces
      //  to indent.
      //
      //  @param indent The number of spaces to indent. Defaults to 3.
      //<

   Util_API std::ostream& operator()(std::ostream&) const;
      //> Manipulate the given output stream with a block indentation style.
      //<

   Util_API static int index() { return soleIndentationIndex; }
      //> The index for the indentation size in the stream buffer extensible
      //  iword array.
      //
      //  @return The indentation index.
      //<

private:
   long theNumSpaces;
      //> The number of spaces to indent this block.
      //<

   static const int soleIndentationIndex;
      //> The singular index into the stream buffer extensible iword array for
      //  the current indentation level.
      //<   

   static std::deque<int> soleIndentationRegistry;
      //> The singular indentation registry used to track block indentation
      //  levels.
      //<   

   friend Util_API std::ostream& endBlock(std::ostream&);
};

}

#endif
