//*****************************************************************************
// FILE:        FormatFilter.h
//
//    Copyright (C)  2013 Kristian Damkjer.
//
// DESCRIPTION:
//> The interface definition for the output format filter.
//<
//
// LIMITATIONS:
//> No known limitations.
//<
//
// SOFTWARE HISTORY:
//> 2013-AUG-04  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#ifndef Damkjer_FormatFilter_HEADER
#define Damkjer_FormatFilter_HEADER

#include <ostream>   // HASA std::ostream interface and data member.
#include <streambuf> // ISA  std::streambuf derivative.

#include "Util/UtilAPI.h"

namespace Damkjer
{

//*****************************************************************************
// CLASS: FormatFilter
//>   An output stream filter to produce line-wrapped and block-indented text.
//<
//*****************************************************************************
class FormatFilter : public std::streambuf
{
public:
   Util_API explicit FormatFilter(std::ostream&, std::size_t lineWidth = 79);
      //> Instantiate a format filter.
      //<

   Util_API virtual ~FormatFilter();
      //> Destruct the format filter and deallocate resources.
      //<

   Util_API static int widthIndex() { return soleLineWidthIndex; }
      //> The index for the line width in the stream buffer extensible iword
      //  array.
      //
      //  @return The line width index.
      //<

private:
   FormatFilter();
      //> Explicitly disable the compiler-generated default constructor. No
      //  definition provided.
      //<

   FormatFilter(const FormatFilter&);
      //> Explicitly disable the compiler-generated copy constructor. No
      //  definition provided.
      //<

   FormatFilter& operator=(const FormatFilter&);
      //> Explicitly disable the compiler-generated assignment operator. No
      //  definition provided.
      //
      //  @return The updated left-hand side when not disabled.
      //<

   int_type overflow(int_type);
      //>   Format the stream with line-wrapping and block indentation.
      //<

   typedef std::basic_string<char_type> FilterString;
      //> The current count of characters in the block.
      //<

   std::size_t theCount;
      //> The current count of characters in the block.
      //<

   std::ostream& theDestination;
      //> The destination stream for formatted stream data.
      //<

   std::streambuf* theDestinationBuf;
      //> The pointer to the wrapped stream buffer.
      //<

   FilterString theBuffer;
      //> The actual buffer contents.
      //<

   std::size_t theLineWidth;
      //> The current formatted line width.
      //<

   static const int soleLineWidthIndex;
      //> The index for the line width in the stream buffer extensible iword
      //  array.
      //<

   static const int soleTabWidth = 8;
      //> Define tab width as 8 spaces.
      //<
};

Util_API std::ostream& sline(std::ostream&);
   //> Insert a line of hyphen ('-') characters into the argument stream
   //  creating the appearance of a single horizontal line.
   //<

Util_API std::ostream& dline(std::ostream&);
   //> Insert a line of equals ('=') characters into the argument stream
   //  creating the appearance of a double horizontal line.
   //<

}

#endif
