//*****************************************************************************
// FILE: UtilAPI.h
//
// COPYRIGHT:
//    Copyright (c) Kristian Damkjer 2013
//
// DESCRIPTION:
//>   Macro definitions for the Util Library API.
//<
//
// LIMITATIONS:
//>   No known limitations.
//<
//
// SOFTWARE HISTORY:
//> 2013-JUL-26  K. Damkjer
//     Initial Coding.
//<
//*****************************************************************************

#ifndef UtilAPI_HEADER
#define UtilAPI_HEADER

//*****************************************************************************
// MACRO: Util_API
//>   Enable switching between exporting interfaces from a dynamic library and
//    importing interfaces into a client application for the Util library API.
//    This macro enables the explicit marking of modules that constitute the
//    Util library API. We can then easily determine the correct action to take
//    in the build process by defining a separate flag when building the
//    library (Util_DLL).
//<
//*****************************************************************************
#ifndef Util_API
   #if _MSC_VER
      // Building a Windows DLL
      #if Util_DLL
         // Building the library.
         #define Util_API __declspec(dllexport)
      #else
         // Using the library.
         #define Util_API __declspec(dllimport)
      #endif
   #else
      // Other shared libraries.
      #define Util_API
   #endif
#endif

#endif
