% demo_curvcolor   Demonstrate point cloud curvature coloring.
%
% File: demo_curvcolor.m
%
% Description:
%    Demonstrate point cloud curvature coloring.
%
% Limitations:
%    No known limitations.
%
% Synopsis:
%    [] = demo_curvcolor()
%
% Inputs:
%    None.
%
% Outputs:
%    None.
%
% Toolbox requirements:
%    None.
%
% Script requirements:
%    None.
%
% Data requirements:
%    None.
%
% References:
%    None.
%
% See Also:
%    None.
%

% Copyright (C)  2012 Kristian L. Damkjer.
%
% Software History:
%    2012-AUG-29   K. Damkjer
%       Initial Coding.

%******************************************************************************
% demo_curvcolor
%******************************************************************************
function demo_curvcolor
   % Demonstrate point cloud curvature coloring. The sample point cloud is
   % hard-coded to be the Armstrong-Enderby Sample LAS file. This can be
   % changed to any desired sample point cloud manually.
   %
   % TODO: Parameterize the sample point cloud input.

dataFile='1815-3_Armstrong-Enderby_Sample1.las';

disp('Building MEX files...');
buildStart=tic;
makeMath('p');
makeVpTree('p');
disp(['  ...done: ' num2str(toc(buildStart)) ' s']);

[path,~,~]=fileparts(mfilename('fullpath'));

srcPath = [path '/../data/source'];
outPath = [path '/../data/results'];

disp('Loading Data...');
loadStart=tic;
sourceData=LasFile([srcPath '/' dataFile]);
disp(['  ...done: ' num2str(toc(loadStart)) ' s']);

disp('Building Database...');
dbStart=tic;
database=VpTree(sourceData.points);
disp(['  ...done: ' num2str(toc(dbStart)) ' s']);

disp('Colorizing by Surface Normals...');
colorStart=tic;
sourceData.color=curvcolor(sourceData.points,database,'n',27);
disp(['  ...done: ' num2str(toc(colorStart)) ' s']);

outFile=[outPath '/curvcolor.las'];
disp(['Saving Results to: ' outFile '...']);
writeStart=tic;
sourceData.saveTo(outFile);
disp(['   ...done: ' num2str(toc(writeStart)) ' s']);
end
