%%
% DEMO_NORMCOLOR
%
% Demonstrates the normcolor function capability.
%
function demo_normcolor
dataFile='1815-3_Armstrong-Enderby_Sample1.las';

disp('Building MEX files...');
buildStart=tic;
makeMath('p');
makeVpTree('p');
disp(['  ...done: ' num2str(toc(buildStart)) ' s']);

[path,~,~]=fileparts(mfilename('fullpath'));

srcPath = [path '/../data/source'];
outPath = [path '/../data/results'];

disp('Loading Data...');
loadStart=tic;
sourceData=LasFile([srcPath '/' dataFile]);
disp(['  ...done: ' num2str(toc(loadStart)) ' s']);

disp('Building Database...');
dbStart=tic;
database=VpTree(sourceData.points);
disp(['  ...done: ' num2str(toc(dbStart)) ' s']);

disp('Colorizing by Surface Normals...');
colorStart=tic;
sourceData.color=normcolor(sourceData.points,database,'n',27);
disp(['  ...done: ' num2str(toc(colorStart)) ' s']);

outFile=[outPath '/normcolor.las'];
disp(['Saving Results to: ' outFile '...']);
writeStart=tic;
sourceData.saveTo(outFile);
disp(['   ...done: ' num2str(toc(writeStart)) ' s']);
end
