//*****************************************************************************
// FILE:        BlockIndent.cpp
//
//    Copyright (C)  2013 Kristian Damkjer.
//
// DESCRIPTION: This class performs the function of block-indenting a stream.
//              It is a convenience manipulator based heavily on the code
//              provided at:
//
//     http://stackoverflow.com/questions/5280858/indenting-paragraph-with-cout
//
// LIMITATIONS: 
//
// SOFTWARE HISTORY:
//> 2012-JUL-26  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#include "BlockIndent.h"

#include <ostream>

namespace Damkjer
{

//*****************************************************************************
// blockIndent static variable instantiation
//*****************************************************************************
const int       blockIndent::INDENT_INDEX = std::ios_base::xalloc();
std::deque<int> blockIndent::INDENTS;

//*****************************************************************************
// BlockIndent::operator()
//*****************************************************************************
Util_API std::ostream& blockIndent::operator()(std::ostream& output) const
{
   // Blocks should always start on a new line, but we don't always need a new
   // line to start a block. What to do?
   output.iword(INDENT_INDEX) += theIndent;
   INDENTS.push_front(theIndent);

   return output;
}

//*****************************************************************************
// endBlock
//*****************************************************************************
Util_API std::ostream& endBlock(std::ostream& output)
{
   // Blocks should always end with a new line, but we don't always need a new
   // line to end a block. What to do?
//   output << "\n";

   if (!blockIndent::INDENTS.empty())
   {
      int decr = blockIndent::INDENTS.front();
      blockIndent::INDENTS.pop_front();
      output.iword(blockIndent::INDENT_INDEX) -= decr;
   }
   
   return output;
}

}
