//*****************************************************************************
// FILE:        FormatFilter.h
//
//    Copyright (C)  2013 Kristian Damkjer.
//
// DESCRIPTION: 
//
// LIMITATIONS: 
//
// SOFTWARE HISTORY:
//> 2012-AUG-04  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#ifndef ConsoleOutput_HEADER
#define ConsoleOutput_HEADER

#include <ostream>
#include <streambuf>

#include "Util/UtilAPI.h"

namespace Damkjer
{

//*****************************************************************************
// CLASS: FormatFilter
//*****************************************************************************
class FormatFilter : public std::streambuf
{
public:
   explicit FormatFilter(std::ostream&, long lineWidth = 79);
      //> Create a block indent stream buffer.
      //<

   Util_API virtual ~FormatFilter();
      //> Free resources allocated by this clas.
      //<

   static int widthIndex() { return LINE_WIDTH_INDEX; }

private:
   FormatFilter(const FormatFilter&);
   FormatFilter& operator=(const FormatFilter&);

   static const int LINE_WIDTH_INDEX;
      //>
      //<

   static const int TAB_WIDTH = 8;
      //> Define tab width as 8 spaces.
      //<

   Util_API int_type overflow(int_type);
      //> This method basically implements a line-buffering stream buffer.
      //
      //  The algorithm is:
      //
      //  - Explicit end of line ("\r" or "\n"): we flush our buffer to the
      //    underlying stream's buffer, and set our record of the line length
      //    to 0.
      //
      //  - An "alert" character: sent to the underlying stream without
      //    recording its length, since it doesn't normally affect the a
      //    appearance of the output.
      //
      //  - Tab: treated as moving to the next tab stop, which is assumed as
      //    happening every tab_width characters.
      //
      //  - Everything else: really basic buffering with word wrapping. We try
      //    to add the character to the buffer, and if it exceeds our line
      //    width, we search for the last space/tab in the buffer and break
      //    the line there. If there is no space/tab, we break the line at the
      //    limit.
      //<

   typedef std::basic_string<char_type> string;

   std::size_t theCount;
      //> The current count of characters in the block.
      //<

   std::ostream& theDestination;
      //>
      //<

   std::streambuf* theDestinationBuf;
      //> The pointer to the wrapped stream buffer.
      //<

   string theBuffer;
      //> The actual buffer contents.
      //<

   long theLineWidth;
      //>
      //<
};

Util_API std::ostream& sline(std::ostream&);
Util_API std::ostream& dline(std::ostream&);

}

#endif
