//*****************************************************************************
// FILE:        ClassHandle.cpp
//
//    Copyright (C)  2012 Kristian Damkjer.
//
// DESCRIPTION: This class is intended to be used to wrap C++ objects for
//              transport across mex function calls in MATLAB.
//
// LIMITATIONS: To preserve the lifetime guarantees of the pointer, default
//              construction, copy construction and assignment are
//              explicitly disallowed.
//
//              The class handle owns the pointer it contains. Thus, when
//              the class handle is destroyed, the pointer is deleted.
//
//              Class handles are forced to be allocated on the heap by
//              using the named constructor idiom. Class handles should be
//              destroyed using the destroyHandleTo template function.
//
// SOFTWARE HISTORY:
//> 2012-OCT-08  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#include "ClassHandle.h"

#include <typeinfo>

namespace Damkjer
{

#define CLASS_HANDLE_SIGNATURE 0xfacade01

//*****************************************************************************
// ClassHandle::ClassHandle
//*****************************************************************************
template<typename BASE>
inline ClassHandle<BASE>::ClassHandle(BASE* pointer)
   : thePointer(pointer)
   , theName(typeid(BASE).name())
   , theSignature(CLASS_HANDLE_SIGNATURE)
{
   mexLock();
}

//*****************************************************************************
// ClassHandle::~ClassHandle
//*****************************************************************************
template<typename BASE>
inline ClassHandle<BASE>::~ClassHandle()
{
   delete thePointer;
   thePointer = 0;
   theSignature = 0;

   mexUnlock();
}

//*****************************************************************************
// ClassHandle::isValid
//*****************************************************************************
template<typename BASE>
inline bool ClassHandle<BASE>::isValid() const
{
   return (theSignature == CLASS_HANDLE_SIGNATURE &&
           theName == typeid(BASE).name());
}

}
