//*****************************************************************************
// FILE:        BlockIndent.h
//
//    Copyright (C)  2013 Kristian Damkjer.
//
// DESCRIPTION: blockIndent
//
//    This class performs the function of block-indenting a stream. It is a
//    convenience manipulator based heavily on the code provided at:
//
//     http://stackoverflow.com/questions/5280858/indenting-paragraph-with-cout
//
// LIMITATIONS: 
//
// SOFTWARE HISTORY:
//> 2012-JUL-26  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#ifndef BlockIndent_HEADER
#define BlockIndent_HEADER

#include <iosfwd>
#include <deque>

#include "Util/UtilAPI.h"
#include "ManipulatorBase.h"

namespace Damkjer
{

//*****************************************************************************
// FUNCTOR: blockIndent
//*****************************************************************************
class blockIndent : public ManipulatorBase<blockIndent>
{
public:
   Util_API explicit blockIndent(long indent = 3)
      : ManipulatorBase<blockIndent>()
      , theIndent(indent)
   {
   }
      //>
      //<

   Util_API std::ostream& operator()(std::ostream&) const;
      //> This method provides a functor interface for operating on
      //  std::ostream objects. This function cannot be templatized, otherwise
      //  compilers will inline the method, thus exposing the private static
      //  variables on the class to the shared library interface. Further, this
      //  method is only valid for std::ostream objects since it manipulates
      //  the object's std::ios_base::iword database in an output streaming
      //  context.
      //<

   static int index() { return INDENT_INDEX; }
      //>
      //<

private:

   friend Util_API std::ostream& endBlock(std::ostream&);
      //>
      //<

   static const int INDENT_INDEX;
      //>
      //<

   static std::deque<int> INDENTS;
      //>
      //<
   
   const long theIndent;
      //>
      //<
};

}

#endif