//*****************************************************************************
// FILE:        ManipulatorBase.h
//
//    Copyright (C)  2013 Kristian Damkjer.
//
// DESCRIPTION: ManipulatorBase
//
//    ManipulatorBase is intended to provide the templated base class for
//    stream manipulators modeled on the "Curiously Recurring Template Pattern"
//    idiom. This idiom provides a simple interface for stream manipulators to
//    be called with anonymous objects on input and output streams.
//
// LIMITATIONS: 
//
// SOFTWARE HISTORY:
//> 2012-Aug-03  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#ifndef ManipulatorBase_HEADER
#define ManipulatorBase_HEADER

namespace Damkjer
{

//*****************************************************************************
// CLASS: ManipulatorBase
//*****************************************************************************
template <class Manipulator>
class ManipulatorBase
{
public:
   template <class Stream>
   Stream& operator()(Stream& stream) const
   {
      // call Manipulator::operator()
      static_cast<const Manipulator&>(*this)(stream);
      return stream;
   }
};

}

//*****************************************************************************
// FUNCTION: operator<<(Ostream&, const ManipulatorBase<Manipulator>&)
//*****************************************************************************
template <class Ostream, class Manipulator>
Ostream& operator<<(Ostream& outputStream,
                    const Damkjer::ManipulatorBase<Manipulator>& manipulate)
{
   return manipulate(outputStream);
}

//*****************************************************************************
// FUNCTION: operator>>(Istream&, const ManipulatorBase<Manipulator>&)
//*****************************************************************************
template <class Istream, class Manipulator>
Istream& operator>>(Istream& inputStream,
                    const Damkjer::ManipulatorBase<Manipulator>& manipulate)
{
   return manipulate(inputStream);
}

#endif
