//*****************************************************************************
// FILE:        TestTestCase.h
//
//    Copyright (C)  2013 Kristian Damkjer.
//
// DESCRIPTION: TestTestCase
//
//    See TestTestCase header for detailed description.
//
// DESCRIPTION: stepReport
//
//    See TestTestCase header for detailed description.
//
// DESCRIPTION: stepIncr
//
//    See TestTestCase header for detailed description.
//
// DESCRIPTION: passArgc
//
//    See TestTestCase header for detailed description.
//
// DESCRIPTION: passArgv
//
//    See TestTestCase header for detailed description.
//
// DESCRIPTION: argvThrow
//
//    See TestTestCase header for detailed description.
//
// LIMITATIONS: 
//
// SOFTWARE HISTORY:
//> 2012-JUL-24  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#include <sstream>

#include "damkjerConfig.h"
#include "TestTestCase.h"
#include "Util/Streams/BlockIndent.h"

namespace Damkjer
{

//*****************************************************************************
// FUNCTOR: stepReport
//*****************************************************************************
class stepReport : public TestCase::TestStep
{
public:
   explicit stepReport(int expected)
      : TestCase::TestStep("sending a message to the step method")
      , theExpectedValue(expected)
   {
   }
      //> This functor constructs with a single parameter representing an
      //  integer expected value.
      //<
   
   bool operator()(TestCase& test) const
   {
      test.report() << "Test Number: " << test.stepNum() << "\n"
                    << "Expecting  : " << theExpectedValue << "\n";
      return (test.stepNum() == theExpectedValue);
   }
      //> The parentheses operator represents the body of the test step
      //  function. It will perform the necessary evaluation and return true if
      //  and only if the test passes.
      //<

private:
   int theExpectedValue;
      //> The expected value for this test step.
      //<
};

//*****************************************************************************
// FUNCTOR: stepIncr
//*****************************************************************************
class stepIncr : public TestCase::TestStep
{
public:
   explicit stepIncr(int expected)
      : TestCase::TestStep("another step to ensure step values increment as "
                           "expected")
      , theExpectedValue(expected)
   {
   }
      //> This functor constructs with a single parameter representing an
      //  integer expected value.
      //<

   bool operator()(TestCase& test) const
   {
      test.report() << "Test Number: " << test.stepNum() << "\n"
                    << "Expecting  : " << theExpectedValue << "\n";
      return (test.stepNum() == theExpectedValue);
   }
      //> The parentheses operator represents the body of the test step
      //  function. It will perform the necessary evaluation and return true if
      //  and only if the test passes.
      //<

private:
   int theExpectedValue;
      //> The expected value for this test step.
      //<
};

//*****************************************************************************
// FUNCTOR: passArgc
//*****************************************************************************
class passArgc : public TestCase::TestStep
{
public:
   explicit passArgc(int expected)
      : TestCase::TestStep("argc pass-through")
      , theExpectedValue(expected)
   {
   }
      //> This functor constructs with a single parameter representing an
      //  integer expected value.
      //<
   
   bool operator()(TestCase& test) const
   {
      test.report() << "argc     : " << test.argc() << "\n"
                    << "Expecting: " << theExpectedValue << "\n";
      return (test.argc() == theExpectedValue);
   }
      //> The parentheses operator represents the body of the test step
      //  function. It will perform the necessary evaluation and return true if
      //  and only if the test passes.
      //<

private:
   int theExpectedValue;
      //> The expected value for this test step.
      //<
};

//*****************************************************************************
// FUNCTOR: passArgv
//*****************************************************************************
class passArgv : public TestCase::TestStep
{
public:
   explicit passArgv(char** expected)
      : TestCase::TestStep("argv pass-through")
      , theExpectedValues(expected)
   {
   }
      //> This functor constructs with a single parameter representing a
      //  character pointer array of expected values.
      //<
   
   bool operator()(TestCase& test) const
   {
      bool check = true;

      for (int i = 0; i < test.argc() && check; ++i)
      {
         std::ostringstream argStm;
         argStm << "argv[" << i << "]";

         std::ostringstream expStm;
         expStm << "Expecting";

         int pad = static_cast<int>(argStm.str().length()) -
                   static_cast<int>(expStm.str().length());

         argStm << std::string(((pad < 0) ? -pad : 0), ' ') << ": ";
         expStm << std::string(((pad > 0) ?  pad : 0), ' ') << ": ";

         test.report() << argStm.str() << test.argv(i) << "\n"
                       << expStm.str() << theExpectedValues[i] << "\n";

         check &= (strcmp(theExpectedValues[i], test.argv(i).c_str()) == 0);
      }

      return check;
   }
      //> The parentheses operator represents the body of the test step
      //  function. It will perform the necessary evaluation and return true if
      //  and only if the test passes.
      //<

private:
   char** theExpectedValues;
      //> The expected values for this test step.
      //<
};

//*****************************************************************************
// FUNCTOR: argvThrow
//*****************************************************************************
class argvThrow : public TestCase::TestStep
{
public:
   argvThrow()
      : TestCase::TestStep("throw from argv")
   {
   }
      //> This functor constructs with a simple default constructor since the
      //  test body is not performing a direct comparison against an expected
      //  value.
      //<
   
   bool operator()(TestCase& test) const
   {
      EXCEPTION_TRY("Damkjer::argvThrow::operator(TestCase&)");

      try
      {
         test.report() << test.argv(test.argc()) << "\n";
         test.report() << "Did not catch an exception!\n";

         // If we get here, we didn't throw: failed test.
         return false;
      }
      catch (const OutOfRange& e)
      {
         test.report() << "Caught expected exception:\n";

         test.report() << blockIndent() << e;
         e.stackTrace(test.report());
         test.report() << endBlock;

         // If we get here, we threw the correct exception: successful test.
         return true;
      }
      catch (...)
      {
         test.report() << "Caught unexpected exception.\n";

         // If we get here, we threw something unexpected: failed test.
         return false;
      }

      EXCEPTION_RETHROW;
   }
      //> The parentheses operator represents the body of the test step
      //  function. It will perform the necessary evaluation and return true if
      //  and only if the test passes.
      //<
};

//*****************************************************************************
// CONSTRUCTOR: TestTestCase::TestTestCase(int, char**)
//*****************************************************************************
TestTestCase::TestTestCase(int argc, char** argv)
   : TestCase(argc, argv,
              "TestCase: Basic Functionality",
              "TestCase_01",
              "This test case tests basic TestCase functionality.")
{
   //***
   // The "step" variable is only needed for this unit test to validate
   // expected increments.
   //***
   int step = 0;

   registerStep(new stepReport(++step));
   registerStep(new stepIncr(++step));
   registerStep(new passArgc(argc));
   registerStep(new passArgv(argv));
   registerStep(new argvThrow());
}

}
