//*****************************************************************************
// FILE:        TestSplayTree.cpp
//
//    Copyright (C)  2013 Kristian Damkjer.
//
// DESCRIPTION: TestSplayTree
//
//    See TestVpTree header for detailed description.
//
// LIMITATIONS: 
//
// SOFTWARE HISTORY:
//> 2012-JUL-24  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#include <iomanip>
#include <sstream>
#include <limits>
#include <cmath>
#include <vector>
#include <typeinfo>

#include "TestSplayTree.h"
#include "Util/Exception/Exception.h"
#include "Util/Dictionaries/SplayTree.h"
#include "Util/Streams/BlockIndent.h"

namespace Damkjer
{


//*****************************************************************************
// FUNCTOR: testChebyshevRnn
//*****************************************************************************
class testSplayInsert : public TestCase::TestStep
{
public:
   testSplayInsert()
      : TestCase::TestStep((std::string(
                            "insert into splay tree")))
   {
   }
      //>
      //<

   bool operator()(TestCase& test) const
   {
      EXCEPTION_TRY("Damkjer::testSplayInsert::operator(TestCase&)");

      // Create the spatially indexed database
      typedef SplayTree<int> SplayTreeT;

      SplayTreeT dictionary;

      dictionary.insert(5);
      dictionary.insert(6);
      dictionary.insert(4);
      dictionary.insert(10);
      dictionary.insert(12);
      dictionary.insert(2);
      dictionary.insert(1);
      dictionary.insert(8);

      dictionary.erase(8);
      dictionary.erase(1);
      dictionary.erase(12);

      // Check the results
      bool passedAll = true;
      bool check;

      test.report() << "Check that dictionary size is five... ";
      check = (dictionary.size() == 5);
      passedAll &= check;
      test.report() << ((check) ? "[OK]" : "[FAILED]") << "\n";

//      for (unsigned int i = 0; i < 1024; ++i)
//      {
//         dictionary.insert((541 * i) & 1023);
//      }

      {

      SplayTreeT dictionary2;

      for (unsigned int i = 0; i < 1048576; ++i)
      {
         dictionary2.insert((524309 * i) & 1048575);
         if (i % 10486 == 0) test.report() << (100.*i/1048575) << "\n";
      }

      test.report() << "Check that dictionary size is 1048576... ";
      check = (dictionary2.size() == 1048576);
      passedAll &= check;
      test.report() << ((check) ? "[OK]" : "[FAILED]") << "\n";

      while (dictionary2.size() > 0)
      {
         dictionary2.erase(dictionary2.head());

         if (dictionary2.size() % 10486 == 0)
         {
            test.report() << (100.*dictionary2.size()/1048575) << "\n";
         }
      }

      }

      return passedAll;

      EXCEPTION_RETHROW;
   }
      //> The parentheses operator represents the body of the test step
      //  function. It will perform the necessary evaluation and return true if
      //  and only if the test passes.
      //<
};

//*****************************************************************************
// CONSTRUCTOR: TestSplayTree::TestSplayTree(int, char**)
//*****************************************************************************
TestSplayTree::TestSplayTree(int argc, char** argv)
   : TestCase(argc, argv,
              "SplayTree: Splay Point Tree Test Suite",
              "SplayTree_01",
              "This test case tests the splay point tree data structure.")
{
   EXCEPTION_TRY("Damkjer::TestSplayTree::TestSplayTree(int, char**)");

   registerStep(new testSplayInsert());

   EXCEPTION_RETHROW;
}

}
