//*****************************************************************************
// FILE:        fastsetdual.cpp
//
//    Copyright (C)  2014 Kristian Damkjer.
//
// DESCRIPTION:
//>   @todo Describe this file
//<
//
// LIMITATIONS:
//>   Does not work for cell-arrays of complex matrices.
//<
//
// SOFTWARE HISTORY:
//> 2014-JAN-13  K. Damkjer
//               Initial Coding.
//<
//*****************************************************************************

#ifdef _OPENMP
#include <omp.h>
#endif

#include <set>
#include <deque>
#include <vector>
#include <sstream>

//***
// Fix "wide char" definition for older versions of MATLAB. This must be placed
// after other includes and before the mex.h include.
//***
#if (defined(MATLAB_MAJOR) && defined(MATLAB_MINOR))
   #if MATLAB_MAJOR <= 7 && MATLAB_MINOR <= 10 && defined(_CHAR16T)
      #define CHAR16_T
   #endif
#endif

#include "mex.h"

//*****************************************************************************
// FUNCTION: mexFunction
//>   The MATLAB Executable Gateway Function.
//
//    @todo Describe this MEX function
//
//    @param nlhs the number of left-hand side parameters.
//    @param plhs the array of left-hand side parameters.
//    @param nrhs the number of right-hand side parameters.
//    @param prhs the array of right-hand side parameters.
//<
//*****************************************************************************
void mexFunction(
        int nlhs, mxArray* plhs[],
        int nrhs, const mxArray* prhs[])
{  
   if (nrhs < 1 || !mxIsCell(prhs[0]))
   {
      mexErrMsgIdAndTxt("Damkjer:fastsetdual:varargin",
                        "Missing or invalid input argument.");
   }

   if (!(mxIsUint32(mxGetCell(prhs[0], 0)) ||
         mxIsUint64(mxGetCell(prhs[0], 0))))
   {
      mexErrMsgIdAndTxt("Damkjer:fastsetdual:varargin",
                        "Invalid input argument.");
   }

   if (nlhs > 1)
   {
      mexErrMsgIdAndTxt("Damkjer:fastsetdual:varargout",
                        "Fast set dual requires a single output.");
   }
   
   mwSize cells = mxGetNumberOfElements (prhs[0]);

   std::vector<const mwSize*> nbrs(cells,0);

   std::set<mwIndex> setUnion;
   
   // Note for future: Ms - neighbors, Ns - 1
   for (mwSize cell = 0; cell < cells; ++cell)
   {      
      nbrs[cell]=(mwIndex*)(mxGetData(mxGetCell(prhs[0], cell)));

      mwSize Ms = mxGetM(mxGetCell(prhs[0], cell));
      
      for (mwSize n = mxGetN(mxGetCell(prhs[0], cell)); n --> 0;)
      {
         for (mwSize m = Ms; m --> 0;)
         {
            setUnion.insert(nbrs[cell][m + Ms * n]);
         }
      }
   }
   
   mwIndex* return_data;
    
   //***
   // Allocating memory for the results to be passed back to MATLAB must take
   // place in a "critical section" since it involves exercising the MEX API.
   //***
   mwSize neighbors = setUnion.size();

   plhs[0] = mxCreateNumericMatrix(0, 0, mxINDEX_CLASS, mxREAL);
   mxSetM(plhs[0], neighbors);
   mxSetN(plhs[0], 1);
   mxSetData(plhs[0], mxMalloc(sizeof(mwIndex)*neighbors*1));
       
   return_data = (mwIndex*)mxGetData(plhs[0]);

   std::size_t nbr = 0;
   
   for (std::set<mwIndex>::iterator itr = setUnion.begin();
        itr != setUnion.end();
        ++itr)
   {
      return_data[nbr] = *itr;
      ++nbr;
   }
   
//    //***
//    // Marking the data for return to MATLAB must take place in a "critical 
//    // section" since it involves exercising the MEX API. This also changes
//    // ownership and memory management responsibilities to MATLAB. We will not
//    // free this data.
//    //***   
// 
//    mxSetCell(plhs[0], 0, returns);
}
