##############################################################################
## FILE:              doxygen-filter
##
##    Copyright (C) 2006 Harris Corporation.  All rights reserved.
##
## DESCRIPTION:       Filters the input files to translate Origin style
##                    documentation into Doxygen style.
##
## LIMITATIONS:       Only really works on one file at a time.
##
## SOFTWARE HISTORY:
##
##  19JAN06 932D PTR#06427-IPL  S. Minster
##               Initial delivery.
##  09APR07 932D PTR#07441-IPL  S. Minster
##               Use doxygen tags instead of HTML.
##  30JUN08 956F PTR#10111-IPL  S. Minster
##               Improved filter to better mark code sections.
##############################################################################

$state = 0;
$swhist = 0;
$filehead = 0;
$isNote = 0;
$isBug = 0;
$isWarn = 0;
$isAttn = 0;
$isPre = 0;
$isInv = 0;
$isPost = 0;
$isFormula = 0;

my $extraClassInfo = "";
if (@ARGV)
{
  $ARGV[0] =~ s/\\/\//g;
  my $fullpath = $ARGV[0];
  my ($path, $file) = ($fullpath =~ /Damkjer\/(.*\/([^\/]+))$/);

  if ($path and $file)
  {
    $extraClassInfo = "$file \"$path\"";
  }
}

while (<>)
{
  $swhist = 1 if (/SOFTWARE HISTORY/);

  if ($isFormula)
  {
     s|^\s*//||;
	 s|\\bm\{|\\boldsymbol\{|g;
	 $isFormula = 0 if ($isFormula && m|\\f\]|);
  }
  if ($filehead)
  {
    if (m|//\s+DESCRIPTION|)
	{
        $filehead = 0;
    }
	else
	{
     s|.+||; chomp;
    }
  }
  if ($swhist && /^\/\/\>/)
  {
    $swhist = 0;
  }
  elsif ($state == 0)
  {
    if (s|^//\>\s*(\S+\|\n)|//\! $1|)
    {
      $state = 1;
    }
    elsif (s|//\>\s*(\S+\|\n)|//\!\< $1|)
    {
      $state = 1;
    }

    s|//\s+CLASS:\s+(\S+)|//\! \\class $1 $extraClassInfo|;
    s|//\s+FUNCTOR:\s+(\S+)|//\! \\class $1 $extraClassInfo|;
    s|//\s+DIRECTORY:\s+(\S+)|//\! \\dir $1|;
    s|//\s+ENUMERATION:\s+(\S+)|//\! \\enum $1|;
    s|//\s+NAMESPACE:\s+(\S+)|//\! \\namespace $1|;

    $filehead = 1 if (m|//\s+FILE:|);
    s|//\s+FILE:\s+(\S+)|//\! \\file $1|;
    s"//\s+DESCRIPTION:(.*|$)"//\! $1";
    $isNote = 1 if (s"//\s+LIMITATIONS:(.*|$)"//\! \\note $1");
    s|^\s*//.*Copyright.*$||;
    s|^\s*//\s*$||;
  }
  elsif ($state == 1)
  {
    if (!s/^(\s*)\/\/( |$)/$1\/\/\!$2/)
    {
      # <pre> seems to strip C++ comments from the output
      # According to bug 315006, this should be fixed, but I saw this error in 1.5.1:
      # http://gcsd.harris.com/orgs/programs/origin/doxygen/3.11/html/d7/d22/classTimer.html#_details
      # See the bug report for the potential workaround:
      # http://bugzilla.gnome.org/show_bug.cgi?id=315006
      $state = 2 if (s|^(\s*)//\-|$1//! \\code\n$1//!|);
      $state = 0 if (s|\/\/<|\/\/\!|);

      if (!$state)
      {
        $isNote = 0;
        $isBug = 0;
        $isWarn = 0;
        $isAttn = 0;
        $isPre = 0;
        $isInv = 0;
        $isPost = 0;
      }
    }
    else
    {
      s|\s+->\s+| \&rarr\; |;
      s|\s+<-\s+| \&larr\; |;
      s|\s+<->\s+| \&harr\; |;

      s|^\s*//\!\s*$|//\! \\note\n| if ($isNote);
      s|^\s*//\!\s*$|//\! \\bug\n| if ($isBug);
      s|^\s*//\!\s*$|//\! \\warning\n| if ($isWarn);
      s|^\s*//\!\s*$|//\! \\attention\n| if ($isAttn);
      s|^\s*//\!\s*$|//\! \\pre\n| if ($isPre);
      s|^\s*//\!\s*$|//\! \\inv\n| if ($isInv);
      s|^\s*//\!\s*$|//\! \\post\n| if ($isPost);
    }
  }
  elsif ($state == 2)
  {
    if (!s|//\-|//!|)
    {
      $state = 1 if (s/(\s*)\/\/( |$)/$1\/\/\! \\endcode\n$1\/\/\!$2/);
      $state = 0 if (s|//<|//\! \\endcode|);
    }
  }

  $isFormula = 1 if (m|\\f\[| && !m|\\f\]|);

  print;
}
