##############################################################################
## FILE:              m2cpp.pl
##
##    Copyright (C) 2013 Harris Corporation.  All rights reserved.
##
## DESCRIPTION:       
##
## LIMITATIONS:       Only really works on one file at a time.
##
## SOFTWARE HISTORY:
##
##############################################################################

use strict;
use warnings;

use Cwd 'abs_path';

sub tee;

my $fullFile = undef; # The full file name passed to the script.
my @fileList = ();    # Allow for classes defined in multiple files.
my $output = "";      # Aggregate transformed text into $output.

if ($#ARGV != 0)
{
   die "Argument must contain filename $#ARGV"
}
else
{
  $fullFile=abs_path($ARGV[0]);
}

# debug
my $filtered = "$fullFile.flt";
#my $out = "";
open (my $out, '>', $filtered) or die "unable to open debug output file, $filtered: $!";

# define MATLAB file grammar
my $bolComment     = "^\\s*\[%\]+\\s*";
my $identifier     = "[_a-zA-Z]\\w*";
my $fqIdentifier   = "$identifier(?:\\.$identifier)*";
my $fqMetaIdent    = "[?]$fqIdentifier";
my $metaList       = "(?:$fqMetaIdent|\{(?:$fqMetaIdent\\s*(?:,\\s*$fqMetaIdent\\s*)*)?\})";
my $superclassList = "$fqIdentifier(?:\\s*&\\s*$fqIdentifier)*";
my $attrValue      = "[\\?\\w.]+";
my $attrValueList  = "(?:$attrValue|\{\\s*(?:$attrValue\\s*(?:,\\s*$attrValue\\s*)*)?\\s*\})";
my $attrItem       = "\\w+(?:\\s*=\\s*$attrValueList)?";
my $attrList       = "\\(\\s*(?:$attrItem\\s*(?:,\\s*$attrItem\\s*)*)?\\s*\\)";
my $argItem        = "(?:$identifier|~)";
my $argList        = "\\(\\s*(?:$argItem\\s*(?:,\\s*$argItem\\s*)*)?\\s*\\)";
my $returns        = "[\\[\\w,\\s\\]]+";

#***
# Determine if there is a special structure associated with the m file. MATLAB
# provides two special folder constructs in the context of class definitions.
#
# 1. @-folders: allow for classes to be defined in multiple files. The @-folder
#               is contained by a path folder, but is not on the path itself.
#               The folder must contain a class definition file of the same
#               name.
# 2. +-folders: allow for package definition. Packages impose a namespace.
#***

my $packageStr = "";
my @packages = ();
my $inClassFolder = 0;

if ($fullFile =~ /(?:[+]?([\w\-]+)[\/\\])+/)
{
   $packageStr = $fullFile;
   $packageStr =~ s/(?:^|[\/\\])[^\/\\]*$//g;
   $packageStr =~ s/(?:^|[\/\\])[^+\/\\][^\/\\]*//g;
   $packageStr =~ s/[+]([^\/\\]+)/$1/g;
   $packageStr =~ s/[\/\\]+/\//g;
   $packageStr =~ s/^[\/]//;
   @packages = split('/',$packageStr);
}

if ($fullFile =~ /^(.*)\@([\w\-]+)[\/\\](\2)\.m/)
{
   #***
   # If we have a .m file inside a (@)-folder with the same name :
   # we will read each file of this folder to acquire the complete class
   # definition
   #
   # TODO: Make sure to associate the captured functions with the class.
   #***
   my $className = $2;
   my $classFile = $className.".m";
   my $pattern = $1."@".$className."/\*.m";
   my @files = glob($pattern);

   $fileList[0] = $fullFile;

   my $i = 0;

   my $classPattern = $classFile;
   $classPattern =~ s/\./\\\./g;
   $inClassFolder = 1;
   
   foreach my $testFile (@files)
   {
      if ($testFile !~ /$classPattern/)
      {
         $fileList[++$i] = $testFile;
      }
   }
}
elsif ($fullFile =~ /^(.*)\@([\w\-]+)[\/\\](.+)\.m/)
{
   # otherwise @-folder, but .m with a different name : ignore it
}
else
{
   # otherwise
   $fileList[0] = $fullFile;
}

# track states
my $className = "";
my $inClass = 0;
my $classIsHandle = 0;
my $classIsSealed = 0;
my $inProps = 0;
my $propGet = "public:";
my $propSet = "public:";
my $propIsAbstract  = 0;
my $propIsConstant  = 0;
my $propIsDependent = 0;
my $inMeths = 0;
my $methAcc = "public:";
my $methIsAbstract  = 0;
my $methIsStatic  = 0;
my $methIsSealed = 0;
my $methDecl = "";
my $methHead = "";
my $inFunc = 0;
my $inParams = 0;
my $inReturns = 0;
my $openControl = 0;
my $startNext = 0;
my $makeDoxyComments = 0;
my $extraLines = 0;
my $isLocalFunc = 0;
my $funcsUseEnd = 1;
my $blankComment = 0;
my $inAnonNamespace = 0;

my @blocks = ();

my %propMeths;

#***
# First pass.
#
# 1. Look for overloaded getters and setters. Don't want to auto-gen them.
# 2. TODO: Determine if functions use "end" or not
# 3. and then?...
#
#***
my $file;
foreach $file (@fileList)
{
   open(my $in, $file) or die "unable to open input file: $file";

   while (<$in>)
   {
      if (/^\s*(?:function)\s*(?:($returns)=)?\s*($fqIdentifier)/)
      {
         push(@blocks,"function");
         
         my $methName = $2 if defined($2);
         
         $propMeths{$methName} = 1 if ($methName =~ m/^[gs]et\./); 
      }
      elsif (/^\s*(?:classdef|properties|methods|events|enumeration|if|for|parfor|switch|try|while)/)
      {
         push(@blocks,"other");
      }
      
      if (/^\s*\bend\b\s*/)
      {
         pop(@blocks) if (scalar @blocks > 0);
      }
   }
   
   $funcsUseEnd = 0 if (scalar(@blocks) > 0);

   close($in);
}

@blocks = ();

# Process each file.
tee($out, "/** MATLAB files, packages, classes and functions. */");
tee($out, "/** \@addtogroup MATLAB MATLAB Code */");
tee($out, "/** \@{ */");
tee($out, "namespace MATLAB {");
tee($out, "/** \@addtogroup MATLAB*/");
tee($out, "/** \@{ */ ");
tee($out, "/** The MATLAB-defined Package: \"$_\". */namespace $_ { /** \@addtogroup MATLAB*//** \@{ */ ") foreach (@packages);

my $funcNo = 0;
foreach $file (@fileList)
{
   open(my $in, $file) or die "unable to open input file: $file";
 
   $file =~ /[\/\\]([^\/\\]*)\.m$/;
   my $baseName = $1;
 
   # Process each line. We must not add or remove lines from the code.
   while (<$in>)
   {
      chomp;
      s/([^%]*)\.\.\./$1\%/;
      
      if (s/($bolComment)file\:/$1\@file /i)
      {
         $makeDoxyComments = 1;
         $inParams = 0;
         $inReturns = 0;
      }
      elsif (s/($bolComment)description\:/$1/i)
      {
         $makeDoxyComments = 1;
         $inParams = 0;
         $inReturns = 0;
      }
      elsif (s/($bolComment)limitations\:/$1\@note /i)
      {
         $makeDoxyComments = 1;
         $inParams = 0;
         $inReturns = 0;
      }
      elsif (s/($bolComment)class\:/$1\@class /i)
      {
         $makeDoxyComments = 1;
         $inParams = 0;
         $inReturns = 0;
      }
      elsif (s/($bolComment)todo\:/$1\@todo /i)
      {
      }
      elsif (s/(?:$bolComment)parameters\:\s*$//i)
      {
         $makeDoxyComments = 1;
         $inParams = 1;
         $inReturns = 0;
         $startNext = 1;
         $extraLines = $extraLines + 1;
      }
      elsif (s/(?:$bolComment)returns\:\s*$//i)
      {
         $makeDoxyComments = 1;
         $inParams = 0;
         $inReturns = 1;
         $startNext = 1;
         $extraLines = $extraLines + 1;
      }
      elsif (!$inFunc && $blankComment && /(?:$bolComment)($identifier(\s+)?)+\:\s*$/i)
      {
         $makeDoxyComments = 0;
         $inParams = 0;
         $inReturns = 0;
      }
      elsif (/(?:$bolComment)[*]{3,}/i)
      {
         $makeDoxyComments = 0;
         $inParams = 0;
         $inReturns = 0;
      }

      elsif (/($bolComment|^)\s*$/)
      {
         $blankComment = 1;
      }
      else
      {
         $blankComment = 0;
      }
      
      if (/^\s*\bend\b\s*/)
      {
         my $closing = "";
         $closing = pop(@blocks) if (scalar @blocks > 0);

         if ($closing =~ /classdef/)
         {
            tee($out, "\};\n");
            $inClass = 0;
            $makeDoxyComments = 0;
         }
         elsif ($closing =~ /properties/)
         {
#            tee($out, "\n");
            tee($out, "/**\@}*/\n");
            $inProps = 0;
            $makeDoxyComments = 0;
         }
         elsif ($closing =~ /methods/)
         {
            tee($out, "\n");
            $inMeths = 0;
            $makeDoxyComments = 0;
         }
         elsif ($closing =~ /function/)
         {
            tee($out, "}") if ($inAnonNamespace);
            tee($out, "}\n");
            $inFunc = 0;
            $makeDoxyComments = 0;
            $inAnonNamespace = 0;
         }
         elsif ($closing =~ /control/)
         {
#            tee($out, "}\n");
            tee($out, "\n");
         }
         else
         {
            tee($out, "\n");
         }
         next;
      }

      if (/^\s*\bfunction\b\s*/ && $inFunc  && !$funcsUseEnd)
      {
         my $closing = "";
         $closing = pop(@blocks) if (scalar @blocks > 0);

         if ($closing =~ /function/)
         {
            tee($out, "}") if ($inAnonNamespace);
            tee($out, "}\n");
            $inFunc = 0;
            $makeDoxyComments = 0;
            $inAnonNamespace = 0;
         }
         else
         {
            push(@blocks, $closing) if ("$closing" ne "");
            warn "Unexpected function structure";
         }
      }
      
      if ($inProps && (/^\s*($identifier)\s*(=\s*[\w\d\{\}\(\)'',\s\[\].]+)?\s*(?:%(.*))?/))
      {
         my $propName = $1;
         my $propValue = "";
         my $propComment = "";
         
         $propValue = $2 if defined($2);
         $propComment = $3 if defined($3);
         
         $propValue =~ s/\([^\)]*(?:\))?//g;
         $propValue =~ s/\{[^\}]*(?:\})?//g;
         $propValue =~ s/\./::/g;

         tee($out, "/** $propComment */") if ($propComment ne "");

         unless ($propIsDependent)
         {
#            tee($out, "private: ");
            tee($out, " const") if ($propIsConstant);
            tee($out, " Property $propName$propValue;");

            unless (exists $propMeths{"get.$propName"})
            {
#               tee($out, "/** Accessor for the property: $propName ");
#               tee($out, "\@retval value The value stored in $propName");
#               tee($out, "*/ ");
#               tee($out, "$propGet ");
#               tee($out, "virtual ") if ($propIsAbstract);
#               tee($out, "Values $propName()");
#               tee($out, "=0") if ($propIsAbstract);
#               tee($out, "; ");
            }

            unless ($propIsConstant || exists $propMeths{"set.$propName"})
            {
#               tee($out, "/** Mutator for the property: $propName ");
#               tee($out, "\@param value the value to set ");
#               tee($out, "\@retval object The object with $propName updated to the argument value") unless ($classIsHandle);
#               tee($out, "*/"); 
#               tee($out, "$propSet ");
#               tee($out, "virtual ") if ($propIsAbstract);
               if ($classIsHandle)
               {
#                  tee($out, "void ");
               }
               else
               {
#                  tee($out, "MATLAB::$className ");
               }
#               tee($out, "$propName(Values value)");
#               tee($out, "=0") if ($propIsAbstract);
#               tee($out, "; ");
            }
         }

         tee($out, "\n");
         next;
      }

      if ($inParams && $startNext && s/^(\s*[%]+\s*)($identifier)\s*-/% \@param $2 /)
      {
         $startNext = 0;
      }
      
      if ($inReturns && $startNext && s/^(\s*[%]+\s*)($identifier)\s*-/% \@retval $2 /)
      {
         $startNext = 0;
      }
      
      if (($inParams || $inReturns) && /^(\s*[%]+\s*)$/)
      {
         $startNext = 1;
      }
      
      if ($inFunc && $makeDoxyComments && /^\s*(?:[^%\s]|\n$)/)
      {
         $makeDoxyComments = 0;
         tee($out, "/** Helper functions visible only to $baseName.m */ namespace {") if ($inAnonNamespace);
         tee($out, "$methHead");
         tee($out, "//\!\n" x $extraLines);
         tee($out, "$methDecl");
         $methHead = "";
         $methDecl = "";
         $extraLines = 0;
      }
      
      if (!$inFunc && ($inMeths || !$inClass))
      {
         my $methRets = "";
         my $methName = "";
         my $methArgs = "()";
         my $methComm = "";
         
         if (/^\s*(function)?\s*(?:($returns)=)?\s*($fqIdentifier)\s*($argList)?\s*(?:%(.*))?/ &&
             (defined($1) || $inMeths))
         {
#            tee($out, "//$_\n");
            
            my $isDecl = ($inMeths && !defined($1));
            
            unless ($isDecl)
            {
               push(@blocks,"function");
               $inFunc = 1;
               $makeDoxyComments = 1;
               ++$funcNo;
            }
            $methRets = $2 if defined($2);
            $methName = $3 if defined($3);
            $methArgs = $4 if defined($4);
            $methComm = $5 if defined($5);

            my $isClassFunc = 0;
            
            $isClassFunc = 1 if ($inMeths);
            $isClassFunc = 1 if ($inClassFolder && !$inMeths && ("$baseName" eq "$methName"));

#            tee($out, "//$methArgs\n");

            my $tempSealed = 0;
            my $methIsCtor = 0;

            # Constructors are always sealed
            if ($methName =~ /^$className$/)
            {
               $tempSealed = 1;
               $methIsCtor = 1;
            }

            # So are accessors and mutators
            if ($methName =~ s/^[gs]et\.//)
            {
               $tempSealed = 1;
            }

#            $methArgs =~ s/,/,MATLAB::Array /g;
            $methArgs =~ s/^\s+//;
            $methArgs =~ s/\s+$//;
            $methArgs =~ s/,/,Value /g;
            $methArgs =~ s/\b~\b/ignored/g;
#            $methArgs =~ s/\(/\(MATLAB::Array /;
            $methArgs =~ s/^([^\(])/Value $1/ unless ($methArgs =~ /^\s*$/);
            $methArgs =~ s/\(/\(Value / unless ($methArgs =~ /^\(\s*\)$/);
            $methArgs =~ s/^\(([^,)]+)(.*)/\($2/ unless (!$isClassFunc || $methIsCtor || $methIsStatic);
            $methArgs =~ s/^\(,/\(/;
               
            $methArgs = "()" if ($methArgs =~ /^\(Value\s*\)$/);

            if ($inMeths)
            {
               $methDecl .= "$methAcc ";

               $methDecl .=  "virtual " unless ($tempSealed || $methIsSealed || $methIsStatic);

               $methDecl .=  "static " if ($methIsStatic);
            }

            if(!$inClass && $funcNo > 1)
            {
               $inAnonNamespace = 1;
            }

            unless($methIsCtor)
            {
               if ($methRets =~ /^\s*$/)
               {
                  $methDecl .=  "void ";
               }
               else
               {
#                  $methArgs =~ s/^\s+//;
#                  $methArgs =~ s/\s+$//;
#                  $methRets =~ s/,/,Value /g;
#                  $methRets =~ s/^([^\[])/Value $1/ unless ($methRets =~ /^\s*$/);
#                  $methRets =~ s/^\[/\[Value / unless ($methRets =~ /^\[\s*\]$/);
                  $methDecl .=  "Values ";
#                  $methDecl .=  "Value ";
#                  $methDecl .=  "$methRets ";
               }
#               $methDecl .=  "$methRets ";
            }

            if ($inClassFolder && !$inMeths && ("$baseName" eq "$methName"))
            {
               $methDecl .= "${className}::";
            }
            $methDecl .= "$methName ";
            $methDecl .= "$methArgs";

            if ($methIsAbstract)
            {
               $methDecl .=  "=0; ";
            }
            elsif ($isDecl)
            {
               $methDecl .=  "; ";
            }
            else
            {
               $methDecl .=  "\{ ";
            }

            $methDecl .=  "//\!< $methComm" unless ($methComm =~ /^\s*$/);
            
            $methDecl .= "\n";
            
            tee($out, "$methDecl") if ($isDecl);
            $methDecl = "" if ($isDecl);
         }
      }
      
      {
         no warnings 'uninitialized';
         s/\'([^\']|\'\')*%([^\']|\'\')*\'/\'$1&#x25;$2\'/;

         if ($makeDoxyComments)
         {
            if ($inFunc)
            {
               s|%|//\!|;
            }
            else
            {
               s|%|//\!|;
            }
         }
         else
         {
            s|%|//|;
         }
         
         s/\'([^\']|\'\')*&#x25;([^\']|\'\')*\'/\'$1%$2\'/;
      }

      if (m|(//\!.*)|)
      {
         $methHead .= "$1\n" if ($inFunc);
         tee($out, "$1\n") unless ($inFunc);
         next;
      }

      #***
      # Class definition blocks
      #
      # classdef := classdef (\(<class_attrs>\))? <class_name> (< <super_classes>)?
      #***
      if (/^\s*(?:classdef)\s+($attrList)?\s*($identifier)\s*(?:<\s*($superclassList))?/)
      {
         #tee($out, "===classdef===\n";
         push(@blocks,"classdef");
         $inClass = 1;
         $makeDoxyComments = 0;
         $classIsHandle = 0;
         $classIsSealed = 0;

         my $classAttrs   = "";
         my $classParents = "";
         my @classParents = ();
         
         $className    = $2;

         # Attributes
         my $classIsAbstract = 0;
         my @baseFriends  = ();

         $classAttrs   = $1 if defined($1);
         $classParents = $3 if defined($3);
 
         if ($classParents !~ /^\s*$/)
         {
            $classIsHandle = 1 if ($classParents =~ /\bhandle\b/);
            $classParents =~ s/\s//g;
            @classParents = split('&',$classParents);
            $classParents =~ s/&/,public /g;
            $classParents = "public MATLAB::$classParents";
#            $classParents = "public $classParents";
         }

         #***
         # Abstract
         # 
         # The C++ equivalent is a class with at least one pure virtual method.
         #***
         if ($classAttrs =~ /abstract\s*=\s*false/i)
         {
            # ignore "Abstract=false" settings.
         }
         elsif ($classAttrs =~ /abstract(?:\s*=\s*true)?/i)
         {
            $classIsAbstract = 1;
         }

         #***
         # AllowedSubclasses
         #
         # The C++ equivalent is a "final" or "leaf" class with specific friend
         # classes. There is no way to directly specify this restriction. It
         # can be imposed through exploiting virtual inheritance.
         #***
         if ($classAttrs =~ /allowedsubclasses\s*=\s*($metaList)/i)
         {
            # AllowedSubclasses always implies Sealed=true.
            $classIsSealed = 1;

            my $allowed = $1;            
            $allowed =~ s/[\{\}\?\s]//g;
            $allowed =~ s/\./::/g;
            @baseFriends = split(',',$allowed);
            @baseFriends = ($className, @baseFriends);
         }
         
         #***
         # ConstructOnLoad
         #
         # The C++ equivalent would be to create a global instance immediately
         # after defining the class.
         #
         # Not yet implemented.
         #***

         #***
         # HandleCompatible
         #
         # No C++ equivalent. Ignore.
         #***

         #***
         # Hidden
         #
         # No C++ equivalent. Ignore.
         #***

         #***         
         # InferiorClasses
         #
         # No C++ equivalent. Ignore.
         #***                  

         #***
         # Sealed
         #
         # The C++ equivalent is a "final" or "leaf" class. There is no way to
         # directly specify this restriction. It can be imposed through
         # exploiting virtual inheritance.
         #
         # Update: C++11 introduces the `final' keyword which performs the
         #         desired modification. Doxygen understands the keyword.
         #***
         if ($classAttrs =~ /sealed\s*=\s*false/i)
         {
            # ignore "Sealed=false" settings.
         }
         elsif ($classAttrs =~ /sealed(?:\s*=\s*true)?/i)
         {
            $classIsSealed = 1;
            @baseFriends = ($className, @baseFriends);
            
         }

         if ($classIsSealed)
         {
            tee($out, "class $_;") foreach (@baseFriends);
            tee($out, "/** Enforce the \"Sealed\" attribute for ${className}. ");
            tee($out, "This class is automatically generated specifically to ");
            tee($out, "illustrate the behavior of the \"Sealed\" class attribute.");
            tee($out, "*/");
            tee($out, "class ${className}Seal {");
            tee($out, "/** Allowed subclass: $_ */ friend class $_;") foreach (@baseFriends);
            tee($out, "/** Prevent public construction of the ${className} seal */");
            tee($out, "private:${className}Seal()\{\}\};");
            
            $classParents = join(', ',("private virtual ${className}Seal",$classParents));
         }

         $classParents = ": $classParents";
         tee($out, "/** \@nosubgrouping */class $className");
         tee($out, " final") if ($classIsSealed);
         tee($out, " $classParents\{\n");         
      }
      elsif (/^\s*(?:properties)\s*($attrList)?/)
      {
         #tee($out, "===properties===\n";
         #***
         # MATLAB properties are more like methods (class functions) than
         # members. Non-dependant properties behave as though a member is
         # backing them and all properties have default get/set methods.
         #***
         push(@blocks,"properties");
         $inProps = 1;

         my $getGrp = "Public";
         my $setGrp = "Public";
         
         my $propAttrs = "";
         $propAttrs = $1 if defined($1);
         $propGet = "public:";
         $propSet = "public:";
         $propIsAbstract  = 0;
         $propIsConstant  = 0;
         $propIsDependent = 0;
         
         #***
         # AbortSet
         #
         # No C++ equivalent. Ignore.
         #***

         #***
         # Abstract
         #
         # Property get and set are pure virtual. Not yey implemented.
         #***
         if ($propAttrs =~ /abstract\s*=\s*false/i)
         {
            # Ignore Constant=false settings.
         }
         elsif ($propAttrs =~ /abstract\s*(?:=\s*true)?/i)
         {
            $propIsAbstract = 1;
         }
                  
         #***
         # Access
         #
         # Restrict access. C++ friendship is granted on a per-class basis, not
         # a per-propery basis, so the friendship here will only be approximate.
         #***
         if ($propAttrs =~ /\baccess\b\s*=\s*private/i)
         {
            $propGet = "private:";
            $propSet = "private:";
            $getGrp = "Private";
            $setGrp = "Private";
         }
         elsif ($propAttrs =~ /\baccess\b\s*=\s*$metaList/i)
         {
            $propGet = "private:";
            $propSet = "private:";
            $getGrp = "Restricted";
            $setGrp = "Restricted";
         }
         elsif ($propAttrs =~ /\baccess\b\s*=\s*protected/i)
         {
            $propGet = "protected:";
            $propSet = "protected:";
            $getGrp = "Protected";
            $setGrp = "Protected";
         }
         elsif ($propAttrs =~ /\baccess\b\s*=\s*public/i)
         {
            $propGet = "public:";
            $propSet = "public:";
            $getGrp = "Public";
            $setGrp = "Public";
         }

         #***
         # Constant
         #
         # Treat property as const.
         #***
         if ($propAttrs =~ /constant\s*=\s*false/i)
         {
            # Ignore Constant=false settings.
         }
         elsif ($propAttrs =~ /constant\s*(?:=\s*true)?/i)
         {
            $propIsConstant = 1;
         }
         
         #***
         # Dependent
         #
         # Treat property as non-member.
         #***
         if ($propAttrs =~ /dependent\s*=\s*false/i)
         {
            # Ignore Dependent=false settings.
         }
         elsif ($propAttrs =~ /dependent\s*(?:=\s*true)?/i)
         {
            $propIsDependent = 1;
         }
         
         #***
         # GetAccess
         #
         # Restrict access. C++ friendship is granted on a per-class basis, not
         # a per-propery basis, so the friendship here will only be approximate.
         #***
         if ($propAttrs =~ /\bgetaccess\b\s*=\s*private/i)
         {
            $propGet = "private:";
            $getGrp = "Private";
         }
         elsif ($propAttrs =~ /\bgetaccess\b\s*=\s*$metaList/i)
         {
            $propGet = "private:";
            $getGrp = "Restricted";
         }
         elsif ($propAttrs =~ /\bgetaccess\b\s*=\s*protected/i)
         {
            $propGet = "protected:";
            $getGrp = "Protected";
         }
         elsif ($propAttrs =~ /\bgetaccess\b\s*=\s*public/i)
         {
            $propGet = "public:";
            $getGrp = "Public";
         }

         #***
         # SetAccess
         #
         # Restrict access. C++ friendship is granted on a per-class basis, not
         # a per-propery basis, so the friendship here will only be approximate.
         #***
         if ($propAttrs =~ /\bsetaccess\b\s*=\s*private/i)
         {
            $propSet = "private:";
            $setGrp = "Private";
         }
         elsif ($propAttrs =~ /\bsetaccess\b\s*=\s*$metaList/i)
         {
            $propSet = "private:";
            $setGrp = "Restricted";
         }
         elsif ($propAttrs =~ /\bsetaccess\b\s*=\s*protected/i)
         {
            $propSet = "protected:";
            $setGrp = "Protected";
         }
         elsif ($propAttrs =~ /\bsetaccess\b\s*=\s*public/i)
         {
            $propSet = "public:";
            $setGrp = "Public";
         }
         
         $makeDoxyComments = 1 unless ($propIsDependent || $propIsAbstract);

         tee($out, "public: /** \@name $getGrp Get Access, $setGrp Set Access Properties *//**\@{*/\n");
#         tee($out, "\n");
      }
      elsif (/^\s*(?:methods)\s*($attrList)?/)
      {
#         tee($out, "//===methods===");
         push(@blocks,"methods");
         $inMeths = 1;
         $makeDoxyComments = 0;

         my $methAttrs = "";
         $methAttrs = $1 if defined($1);
         $methAcc = "public:";
         $methIsAbstract  = 0;
         $methIsStatic  = 0;
         $methIsSealed = 0;
         
         #***
         # Abstract
         #
         # Property get and set are pure virtual. Not yey implemented.
         #***
         if ($methAttrs =~ /abstract\s*=\s*false/i)
         {
            # Ignore Constant=false settings.
         }
         elsif ($methAttrs =~ /abstract\s*(?:=\s*true)?/i)
         {
            $methIsAbstract = 1;
            $makeDoxyComments = 1;
         }
          
         #***
         # Access
         #
         # Restrict access. C++ friendship is granted on a per-class basis, not
         # a per-propery basis, so the friendship here will only be approximate.
         #***
         if ($methAttrs =~ /\baccess\b\s*=\s*private/i)
         {
            $methAcc = "private:";
         }
         elsif ($methAttrs =~ /\baccess\b\s*=\s*$metaList/i)
         {
            $methAcc = "private:";
         }
         elsif ($methAttrs =~ /\baccess\b\s*=\s*protected/i)
         {
            $methAcc = "protected:";
         }
         elsif ($methAttrs =~ /\baccess\b\s*=\s*public/i)
         {
            $methAcc = "public:";
         }

         #***
         # Hidden
         #
         # No C++ equivalent. Ignore.
         #***
         
         #***
         # Sealed
         #
         # Treat method as final.
         #***
         if ($methAttrs =~ /sealed\s*=\s*false/i)
         {
            # Ignore Sealed=false settings.
         }
         elsif ($methAttrs =~ /sealed\s*(?:=\s*true)?/i)
         {
            $methIsSealed = 1;
         }
         
         #***
         # Static
         #
         # Class method.
         #***
         if ($methAttrs =~ /static\s*=\s*false/i)
         {
            # Ignore Static=false settings.
         }
         elsif ($methAttrs =~ /static\s*(?:=\s*true)?/i)
         {
            $methIsStatic = 1;
         }

         tee($out, "\n");
      }
      elsif (/^\s*(if|for|parfor|switch|try|while)(.*)/)
      {
#         tee($out, "//===control===");
         push(@blocks,"control");
#         my $ctrl = $1;
#         my $stmt = $2;
#         $stmt =~ s/~/\!/g;
#         $stmt =~ s/:/,/g;
#         $stmt =~ s/($identifier)\.($identifier)/$1::$2/g;
#         $stmt =~ s/\[$identifier(?:,$identifier)*\]/MATLAB::Array/g;
#         $stmt =~ s/[\[]/\(/g;
#         $stmt =~ s/[\)]/\)/g;
#         $stmt =~ s/($identifier)\{(.*)\}/$1\[$2\]/g;
#         $stmt =~ s/''/\"/g;
#         $stmt =~ s/\'/\"/g;
#         tee($out, "$ctrl$stmt";
#         
#         if ($_ !~ /[^%]*\.\.\./)
#         {
#            tee($out, "{";
#         }
#         else
#         {
#            $openControl = 1;
#         }
         
         tee($out, "\n");
      }
      else
      {
         #tee($out, "===other===\n");
#         s/~/\!/g;
#         s/:/,/g;
#         s/($identifier)\.($identifier)/$1::$2/g;
#         s/\[$identifier(?:,$identifier)*\]/MATLAB::Array/g;
#         s/[\[]/\(/g;
#         s/[\]]/\)/g;
#         s/($identifier)\{(.*)\}/$1\[$2\]/g;
#         s/''/\"/g;
#         s/\'/\"/g;
#         
#         unless ($inFunc && $makeDoxyComments)
#         {
#            if ($openControl && $_ !~ /[^%]*\.\.\./)
#            {
#               $openControl = 0;
#               tee($out, "$_\{");
#            }
#            else
#            {
#               s|([^%]*)\.\.\.|$1//|;
#               tee($out, "$_");
#            }
#         }

         tee($out, "\n") unless ($inFunc && $makeDoxyComments);
      }
      

   }

   close $in;
}

tee($out, "}") if ($inFunc);

tee($out, "/**\@}*/}" x scalar(@packages));
tee($out, "/**\@}*/}/**\@}*/\n");

close $out;

sub tee (@)
{
   my $handle = shift;
   print $handle @_;
   print @_;
}