classdef (Sealed = true) GTModelTypeGeoKey < GeoKey
    properties
        code = 0
    end
    
    properties (GetAccess = private,Constant = true)
        codes = containers.Map(...
            {1,2,3},...
            {'Projection Coordinate System',...
            'Geographic latitude-longitude System',...
            'Geocentric (X,Y,Z) Coordinate System'});
    end

    properties (Dependent)
        interpretation
    end
    
    methods
        function vlr = GTModelTypeGeoKey(varargin)
            if (nargin == 1)
                arg=varargin{1};
                if (~(isnumeric(arg)&&isscalar(arg)&&mod(arg,1)==0&&...
                        arg>=0&&arg<=65535))
                    error('GTModelTypeGeoKey:InitError',...
                        'Invalid Model Type');
                end
                vlr.code = varargin{1};
            end
        end
        
        function meaning = get.interpretation(vlr)
            % Required accessor for dependent property: interpretation
            if (vlr.code == 0)
                meaning = 'Undefined Projection System Type';
            elseif (vlr.code >= 1 && vlr.code <= 32766)
                if (vlr.codes.isKey(vlr.code))
                    meaning = vlr.codes(vlr.code);
                else
                    meaning = 'GeoTIFF Reserved Code';
                end
            elseif (vlr.code == 32767)
                meaning = 'User-Defined Projection System Type';
            elseif (vlr.code >= 32768 && vlr.code <= 65535)
                meaning = 'Private User Implementation';
            else
                error('GTModelTypeGeoKey:InvalidModelType',...
                    'Invalid Model Type');
            end
        end
    end
end
