classdef (Sealed = true) VerticalUnitsGeoKey < GeoKey
   properties
      code = 2
   end
   
   properties (GetAccess = private,Constant = true)
      codes = containers.Map(...
         {9001,...
         9002,...
         9003,...
         9004,...
         9005,...
         9006,...
         9007,...
         9008,...
         9009,...
         9010,...
         9011,...
         9012,...
         9013,...
         9014,...
         9015},...
         {'Meter',...
         'Foot',...
         'Foot (US Survey)',...
         'Foot (Modified American)',...
         'Foot (Clarke)',...
         'Foot (Indian)',...
         'Link',...
         'Link (Benoit)',...
         'Link (Sears)',...
         'Chain (Benoit)',...
         'Chain (Sears)',...
         'Yard (Sears)',...
         'Yard (Indian)',...
         'Fathom',...
         'International Nautical Mile'});
   end
   
   properties (Dependent)
      interpretation
   end
   
   methods
      function vlr = VerticalUnitsGeoKey(varargin)
         if (nargin == 1)
            if (~vlr.codes.isKey(varargin{1}))
               error('VerticalUnitsGeoKey:InitError',...
                  'Unknown Unit');
            end
            vlr.code = varargin{1};
         end
      end
      
      function meaning = get.interpretation(vlr)
         % Required accessor for dependent property: interpretation
         
         meaning = vlr.codes(vlr.code);
      end
      
   end
end
