% lasfProjVlrFactory   Concrete factory for LAS File Projection VLR objects
%
% File:
%    lasfProjVlrFactory.m
%
% Description:
%    This MATLAB function provides an interface similar to a concrete factory
%    in the abstract factory design pattern for constructing defined LAS File
%    Projection VLR objects.
%
% Limitations:
%    None.
%
% Synopsis:
%    [vlr] = lasfProjVlrFactory(vlrHeader)
%
% Inputs:
%    vlrHeader  - A LAS VLR object containing populated header data
%
% Outputs:
%    vlr  - A specialized LAS File VLR Projection object
%
% Other m-files required:
%    LasVlr.m
%    LasfProjGeoKeyDirectoryTagVLR.m
%    LasfProjGeoDoubleParamsTagVLR.m
%    LasfProjGeoAsciiParamsTagVLR.m
%
% MAT-files required:
%    None.
%
% References:
%    http://asprs.org/a/society/committees/standards/asprs_las_format_v12.pdf
%
% See Also:
%    LasFile
%    LasVlr
%    lasVlrFactory
%    LasfProjGeoKeyDirectoryTagVLR
%    LasfProjGeoDoubleParamsTagVLR
%    LasfProjGeoAsciiParamsTagVLR
%

% Software History:
%    2012-AUG-29   K. Damkjer
%       Initial Coding.
%    2013-JUN-17   K. Damkjer
%       Additional Commenting.
%

function [vlr] = lasfProjVlrFactory(vlrHeader)
switch vlrHeader.recordID
   case 34735
      vlr = LasfProjGeoKeyDirectoryTagVLR(vlrHeader);
   case 34736
      vlr = LasfProjGeoDoubleParamsTagVLR(vlrHeader);
   case 34737
      vlr = LasfProjGeoAsciiParamsTagVLR(vlrHeader);
   otherwise
      disp(vlrHeader.userID);
      disp(vlrHeader.recordID);
      disp(vlrHeader.description);
end
end
