% lasfSpecVlrFactory   Concrete factory for LAS File Specification VLR objects
%
% File:
%    lasfSpecVlrFactory.m
%
% Description:
%    This MATLAB function provides an interface similar to a concrete factory
%    in the abstract factory design pattern for constructing defined LAS File
%    Specification VLR objects.
%
% Limitations:
%    LasfSpecHistogramVLR and LasfSpecTextAreaVLR are currently undefined.
%
% Synopsis:
%    [vlr] = lasfSpecVlrFactory(vlrHeader)
%
% Inputs:
%    vlrHeader  - A LAS VLR object containing populated header data
%
% Outputs:
%    vlr  - A specialized LAS File VLR Specification object
%
% Other m-files required:
%    LasVlr.m
%    LasfSpecClassification.m
%
% MAT-files required:
%    None.
%
% References:
%    http://asprs.org/a/society/committees/standards/asprs_las_format_v12.pdf
%
% See Also:
%    LasFile
%    LasVlr
%    lasVlrFactory
%    LasfSpecClassificationVLR
%

% Software History:
%    2012-AUG-29   K. Damkjer
%       Initial Coding.
%    2013-JUN-17   K. Damkjer
%       Additional Commenting.
%

function [vlr] = lasfSpecVlrFactory(vlrHeader)
switch vlrHeader.recordID
    case 0
        vlr = LasfSpecClassificationVLR(vlrHeader.data);
    case 2
        vlr = LasfSpecHistogramVLR(vlrHeader.data);
    case 3
        vlr = LasfSpecTextAreaVLR(vlrHeader.data);
    otherwise
      disp(vlrHeader.userID);
      disp(vlrHeader.recordID);
      disp(vlrHeader.description);
end
end
