function [ Q, center ] = quadricfit( pnts )
%ELLIPSOIDFIT Summary of this function goes here
%   Detailed explanation goes here

size(pnts)

if (size(pnts,1)==3)
   pnts=[pnts;ones(1,size(pnts,2))];
end

if (size(pnts,1)~=4)
   error 'Points must be 3D'
end

A=[(pnts(1,:).^2)', ...         %x^2
   (pnts(1,:).*pnts(2,:))', ... %xy
   (pnts(1,:).*pnts(3,:))', ... %xz
   (pnts(2,:).^2)', ...         %y^2
   (pnts(2,:).*pnts(3,:))', ... %yz
   (pnts(3,:).^2)', ...         %z^2
   pnts(1,:)', ...              %x
   pnts(2,:)', ...              %y
   pnts(3,:)', ...              %z
   pnts(4,:)'];                 %w

QQ=null(A);

Q=[QQ(1),  QQ(2)/2,QQ(3)/2,QQ(7)/2;
   QQ(2)/2,QQ(4),  QQ(5)/2,QQ(8)/2;
   QQ(3)/2,QQ(5)/2,QQ(6),  QQ(9)/2;
   QQ(7)/2,QQ(8)/2,QQ(9)/2,QQ(10)];

Q=Q/Q(4,4);

center=Q(1:3,1:3)\Q(1:3,4);
end

