% timeFormat   Format seconds as hh:mm:ss.000
%
% File:
%    timeFormat.m
%
% Description:
%    This MATLAB function converts a number representing seconds to a string
%    format as hh:mm:ss.000.
%
% Limitations:
%    None.
%
% Synopsis:
%    [msg] = timeFormat(seconds)
%
% Inputs:
%    seconds  - A numeric representing time in seconds.
%
% Outputs:
%    msg  - A string representation of seconds in hh:mm:ss.000 format.
%
% Toolbox requirements:
%    None.
%
% Script requirements:
%    None.
%
% Data requirements:
%    None.
%
% References:
%    None.
%
% See Also:
%    None.
%

% Copyright (C)  2013 Kristian L. Damkjer.
%
% Software History:
%    2013-JUN-20   K. Damkjer
%       Initial Coding.
%

function [msg] = timeFormat(seconds)

h = floor(seconds/3600);
m = floor((seconds - h * 3600)/60);
s = mod(seconds, 60);

if (h > 0)
   msg = [num2str(h,'%02d') ':' num2str(m,'%02d') ':' num2str(s,'%06.3f')];
elseif (m > 0)
   msg = [num2str(m,'%02d') ':' num2str(s,'%06.3f')];
else
   msg = ['0:' num2str(s,'%06.3f')];
end
   
end

