%%
% DEMO_DIMCOLOR
%
% Demonstrates the dimcolor function capability.
%
function demo_dimcolor
dataFile='Serpent Mound Model LAS Data.las';
neighbors=20;

disp('Building MEX files...');
buildStart=tic;
makeMath('p');
makeVpTree('p');
disp(['  ...done: ' timeFormat(toc(buildStart))]);

[pathstr,~,~] = fileparts(mfilename('fullpath'));
[pathstr,~,~] = fileparts(pathstr);

srcPath = fullfile(pathstr, 'data', 'source');
outPath = fullfile(pathstr, 'data', 'results');

disp('Loading Data...');
loadStart=tic;
sourceData=LasFile(fullfile(srcPath, dataFile));
disp(['  ...done: read ' num2str(size(sourceData.points,2)) ...
      ' points in ' timeFormat(toc(loadStart))]);

disp('Building Database...');
dbStart=tic;
database=VpTree(sourceData.points);
disp(['  ...done: ' timeFormat(toc(dbStart))]);

disp('Colorizing by Inherent Dimensionality...');
colorStart=tic;
sourceData.color=dimcolor(sourceData.points,database,'n',neighbors);
disp(['  ...done: evaluated ' num2str(size(sourceData.points,2)) ...
      ' points in ' num2str(neighbors) '-point neighborhoods in ' ...
      timeFormat(toc(colorStart))]);

outFile=fullfile(outPath, 'dimcolor.las');
disp(['Saving Results to: ' outFile '...']);
writeStart=tic;
sourceData.saveTo(outFile);
disp(['   ...done: wrote '  num2str(size(sourceData.points,2)) ...
      ' points in ' timeFormat(toc(writeStart))]);
end
