%%
% DEMO_SPATIAL_ANALYZE
%
% Demonstrates the spatial analyzer function capability.
%
function demo_spatial_analyze
%dataFile='Serpent Mound Model LAS Data.las';
dataFile='1815-3_Armstrong-Enderby_Sample1.las';
neighbors=20;
%counts=10:20;

disp('Building MEX files...');
buildStart=tic;
makeMath('p');
makeVpTree('p');
disp(['  ...done: ' num2str(toc(buildStart)) 's']);

[path,~,~]=fileparts(mfilename('fullpath'));

srcPath = [path '/../data/source'];
outPath = [path '/../data/results'];

disp('Loading Data...');
loadStart=tic;
sourceData=LasFile([srcPath '/' dataFile]);
disp(['  ...done: read ' num2str(size(sourceData.points,2)) ' points in ' ...
      num2str(toc(loadStart)) 's']);

disp('Building Database...');
dbStart=tic;
database=VpTree(sourceData.points);
disp(['  ...done: ' num2str(toc(dbStart)) 's']);

disp('Performing Spatial Analysis...');
resultsStart=tic;
results=spanalyze(sourceData.points,database,'n',neighbors);
%results=spanalyze(sourceData.points,database,'c',counts);
disp(['  ...done: evaluated ' num2str(size(sourceData.points,2)) ' points in ' ...
      num2str(neighbors) '-point neighborhoods in ' ...
      num2str(toc(resultsStart)) 's']);

sourceData.color=[uint16(double(intmax('uint16'))*results.dimensionality)];
   
outFile=[outPath '/dimcolor.las'];
disp(['Saving Results to: ' outFile '...']);
writeStart=tic;
sourceData.saveTo(outFile);
disp(['   ...done: wrote '  num2str(size(sourceData.points,2)) ' points in ' ...
      num2str(toc(writeStart)) 's']);
end
