%%
% MAKEMATH(...)
%
% Build Math library MEX functions and classes.
%
% OPTIONS:
%
%   Variable options may be provided as shortcuts as long as they resolve
%   to a unique option.
%
%   Make options are as follows:
%
%   'debug'   : Compile with debug flags and fully populated symbol table.
%
%   'parallel': Enable OpenMP pragmas for multi-threaded computing.
%
%   'verbose' : Provide verbose output while compiling.
%
%   'warnings': Provide compiler warning output for production-ready code.
%               Implies 'verbose'.
%
function makeMath(varargin)

command = 'mex -largeArrayDims -D_USE_MATH_DEFINES';

flags = {'verbose', 'debug', 'warnings', 'parallel'};
options=[];

while ~isempty(varargin)
    flag = varargin{1};
    % If the property has been supplied in a shortened form, lengthen it
    iFlag = find(strncmpi(flag, flags, length(flag)));
    
    if isempty(iFlag)
       options=[options ' ' flag];
       error('Damkjer:makeVpsTree:InvalidFlag', ['Invalid Flag: ' flag]);
    elseif length(iFlag) > 1
        error('Damkjer:makeColorize:AmbiguousFlag', ...
              ['Supplied shortened flag is ambiguous: ' flag]);
    else
        flag = flags{iFlag};

        switch flag
            case 'verbose'
                command = [command ' -v'];
            case 'debug'
                command = [command ' -g'];
            case 'parallel'
                if (ispc)
                    command = [command ' COMPFLAGS="$COMPFLAGS /openmp"'];
                else
                    command = [command ' CFLAGS="\$CFLAGS -fopenmp"' ...
                                       ' CXXFLAGS="\$CXXFLAGS -fopenmp"' ...
                                       ' LDFLAGS="\$LDFLAGS -fopenmp"'];
                end
            case 'warnings'
                if (ispc)
                    command = [command ' -v COMPFLAGS="$COMPFLAGS -W3"'];
                else
                    command = [command ' -v' ...
                                       ' CFLAGS="\$CFLAGS -Wall -Wextra"' ...
                                       ' CXXFLAGS="\$CXXFLAGS -Wall -Wextra"'];
                end
            otherwise
                error('Damkjer:makeVpsTree:NotImplementedFlag', ...
                    ['Flag recognized, but not supported (oops): ' flag]);
        end % switch property
    end

    varargin(1) = [];
end % while

[path,~,~]=fileparts(mfilename('fullpath'));
command = [command options ' -I' path '/../../.. -outdir ' path ' ' path '/'];

eval([command 'fastcov.cpp']);
eval([command 'fastcenter.cpp']);

end
