%%READXYZ    Read XYZ formatted file.
%   [POINTS,FRAMES,PIXELS] = READXYZ(FILENAME) parses the file FILENAME for
%   binary point tuples. POINTS is a 3-by-N collection of world coordinate
%   points, FRAMES is a 1-by-N collection of IFOV frame indices for the
%   associated points, and PIXELS is a 1-by-N collection of IFOV pixel
%   indices for the associated points.
%
%   FILENAME is a string containing the name of the file to be opened.  
%
%   PIXELS indices follow the convention that negative indices capture
%   information about IFOV. Index -5 is the effective center of the IFOV
%   while indices -1 through -4 capture the IFOV corners at the top of the
%   range gate.
%
%   See also FOPEN.

%   Copyright 2012 Kristian Linn Damkjer
function [X,F,P] = readXYZ(filename)

% Attempt to open the file for reading.
[fid, msg] = fopen(filename, 'r');

% If unsuccessful, let the user know why and return empy tuples.
if (fid < 0)
    disp(msg);
    X = zeros(3,0);
    F = zeros(1,0,'int32');
    P = zeros(1,0,'int32');
    return;
end

% Otherwise, parse the data.
dirStruct = dir(filename);


numPts = (dirStruct.bytes-24)/20;

tic;

offsets = fread(fid, 3, 'double=>double');

temp = reshape(fread(fid, inf, 'single=>single'),5,numPts);

size(offsets)
size(temp)

X = bsxfun(@plus, temp(1:3,:), offsets);
F = typecast(temp(4,:),'int32');
P = typecast(temp(5,:),'int32');

disp(['Time to parse file: ' num2str(toc) 's']);

fclose(fid);

return;

end
