//****************************************************************************
// FILE:        SplayTree.h
//
//    Copyright (C)  2013 Kristian Damkjer.
//
// DESCRIPTION:
//>   The interface definition for splay trees.
//<
//
// LIMITATIONS:
//>   This class template file follows the template inclusion pattern. This
//    header file should be the only file included by clients wishing to
//    instantiate a VpTree specialization.
//<
//
// SOFTWARE HISTORY:
//
//> 2013-DEC-02  K. Damkjer
//               Initial Coding.
//<
//****************************************************************************
#ifndef Damkjer_SplayTree_HEADER
#define Damkjer_SplayTree_HEADER

namespace Damkjer
{

//*****************************************************************************
// CLASS: LPt
//>   A LiDAR point type.
//
//    @tparam MetricT The metric search space.
//<
//*****************************************************************************
template<typename T>
class LPt
{
public:
   typedef T value_type;
   typedef T& reference;
   typedef const T& const_reference;
   typedef T* iterator;
   // const_iterator;
   // differe

   LPt();

   LPt(const LPt&);

   virtual ~LPt(void);


};

}

#endif
